package net.doo.snap.lib.snap.camera.barcode.result;

import android.app.Activity;

import com.google.zxing.client.result.URIParsedResult;

import net.doo.snap.lib.R;
import net.doo.snap.lib.util.ThemesHelper;

import java.util.Locale;

/**
 * Offers appropriate actions for URLS.
 */
public final class URIResultHandler extends ResultHandler {
    // URIs beginning with entries in this array will not be saved to history or copied to the
    // clipboard for security.
    private static final String[] SECURE_PROTOCOLS = {
            "otpauth:"
    };

    private static final int[] buttons = {
            R.string.button_open_browser
    };
    private static final int OPEN_URI = 0;

    public URIResultHandler(Activity activity, URIParsedResult result) {
        super(activity, result);
    }

    @Override
    public URIParsedResult getResult() {
        return (URIParsedResult) super.getResult();
    }

    @Override
    public int getButtonCount() {
        return buttons.length;
    }

    @Override
    public int getButtonText(int index) {
        return buttons[index];
    }

    @Override
    public void handleButtonPress(int index) {
        String uri = getResult().getURI();
        if (index == OPEN_URI) {
            openURL(uri);
        }
    }

    @Override
    public String getDisplayTitle() {
        return getResult().getURI();
    }

    @Override
    public String getDisplaySubtitle() {
        return null;
    }

    @Override
    public String getDisplayText() {
        return null;
    }

    @Override
    public boolean areContentsSecure() {
        String uri = getResult().getURI().toLowerCase(Locale.ENGLISH);
        for (String secure : SECURE_PROTOCOLS) {
            if (uri.startsWith(secure)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public int getDisplayIconRes() {
        return ThemesHelper.getResourceId(getActivity(), R.attr.ui_qr_ico_barcode);
    }
}
