package net.doo.snap.lib.snap.edit.events;

/**
 * Invoked when name of document was changed
 */
public class DocumentRenamedEvent {

    private final String newName;

    /**
     * @param newName new name of the document
     */
    public DocumentRenamedEvent(String newName) {
        this.newName = newName;
    }

    /**
     * @return new name of the document
     */
    public String getNewName() {
        return newName;
    }
}
