/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.lib;

import android.content.Context;
import android.content.pm.PackageManager;
import com.google.inject.AbstractModule;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import net.doo.snap.lib.billing.AmazonBillingManagerImpl;
import net.doo.snap.lib.billing.BillingManager;
import net.doo.snap.lib.billing.BillingManagerImpl;
import net.doo.snap.lib.snap.camera.HostProvider;
import net.doo.snap.lib.snap.camera.SnapCameraHost;
import net.doo.snap.lib.snap.camera.barcode.BarcodeDetector;
import net.doo.snap.lib.snap.edit.EditLock;
import net.doo.snap.lib.util.bitmap.BitmapLruCache;
import roboguice.inject.ContextSingleton;

public class SnapModule
extends AbstractModule {
    private String installationSource;

    @Inject
    public SnapModule(Context context) {
        PackageManager pm = context.getPackageManager();
        this.installationSource = pm.getInstallerPackageName(context.getPackageName());
    }

    protected void configure() {
        this.bind(BitmapLruCache.class).in(Singleton.class);
        this.bind(EditLock.class).in(ContextSingleton.class);
        if ("com.amazon.venezia".equals(this.installationSource)) {
            this.bind(BillingManager.class).to(AmazonBillingManagerImpl.class);
        } else {
            this.bind(BillingManager.class).to(BillingManagerImpl.class);
        }
        this.bind(BarcodeDetector.class).in(Singleton.class);
        this.bind(SnapCameraHost.class).toProvider(HostProvider.class);
    }
}

