/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.lib.snap;

import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import android.support.v4.view.PagerAdapter;
import android.view.View;
import android.view.ViewGroup;
import com.google.inject.Inject;
import net.doo.snap.lib.persistence.DocumentDraft;
import net.doo.snap.lib.persistence.Page;
import net.doo.snap.lib.persistence.PageFactory;
import net.doo.snap.lib.snap.camera.CameraPreviewFragment;
import net.doo.snap.lib.snap.preview.ImagePreviewFragment;

public class PreviewFragmentPagerAdapter
extends PagerAdapter {
    public static final float FULL_PAGE_WIDTH = 1.0f;
    public static final float PREVIEW_PAGE_WIDTH = 0.7f;
    private static final String CAMERA_FRAGMENT_TAG = "CAMERA_FRAGMENT_TAG";
    private static final String FRAGMENT_TAG_PREFIX = "doo:";
    private FragmentManager fragmentManager;
    private FragmentTransaction currentTransaction;
    private Fragment currentPrimaryItem;
    private DocumentDraft documentDraft = new DocumentDraft(new Page[0]);
    @Inject
    private PageFactory pageFactory;

    @Inject
    public PreviewFragmentPagerAdapter(FragmentManager fragmentManager) {
        this.fragmentManager = fragmentManager;
    }

    protected Fragment getItem(int position) {
        return position == this.documentDraft.size() ? new CameraPreviewFragment() : ImagePreviewFragment.newInstance(this.documentDraft.getPage(position));
    }

    public CameraPreviewFragment getCameraFragment() {
        return (CameraPreviewFragment)this.fragmentManager.findFragmentByTag(CAMERA_FRAGMENT_TAG);
    }

    public ImagePreviewFragment getFragment(ViewGroup container, int position) throws ClassCastException, IndexOutOfBoundsException {
        return (ImagePreviewFragment)this.instantiateItem(container, position);
    }

    public long getItemId(int position) {
        long id2 = position == this.documentDraft.size() ? 0x7F070007L : (long)this.documentDraft.getPage(position).hashCode();
        return id2;
    }

    public int getItemPosition(Object object) {
        if (object instanceof CameraPreviewFragment) {
            return this.getCount() - 1;
        }
        ImagePreviewFragment previewFragment = (ImagePreviewFragment)((Object)object);
        int pageIndex = this.documentDraft.getPosition(previewFragment.getPage());
        if (pageIndex != -1) {
            return pageIndex;
        }
        return -2;
    }

    public int getPagePosition(Page page) {
        return this.documentDraft.getPosition(page);
    }

    public void setPrimaryItem(ViewGroup container, int position, Object object) {
        Fragment fragment = (Fragment)object;
        if (fragment != this.currentPrimaryItem) {
            if (this.currentPrimaryItem != null) {
                this.currentPrimaryItem.setMenuVisibility(false);
                this.currentPrimaryItem.setUserVisibleHint(false);
            }
            if (fragment != null) {
                fragment.setMenuVisibility(true);
                fragment.setUserVisibleHint(true);
            }
            if (fragment instanceof ImagePreviewFragment) {
                ((ImagePreviewFragment)fragment).setSelected(true);
            }
            if (this.currentPrimaryItem instanceof ImagePreviewFragment) {
                ((ImagePreviewFragment)this.currentPrimaryItem).setSelected(false);
            }
            this.currentPrimaryItem = fragment;
        }
    }

    public Fragment instantiateItem(ViewGroup container, int position) {
        this.verifyTransactionCreated();
        long itemId = this.getItemId(position);
        String name = PreviewFragmentPagerAdapter.makeFragmentName(container.getId(), itemId);
        Fragment fragment = this.fragmentManager.findFragmentByTag(name);
        if (fragment != null) {
            this.currentTransaction.attach(fragment);
        } else {
            fragment = this.getItem(position);
            this.currentTransaction.add(container.getId(), fragment, PreviewFragmentPagerAdapter.makeFragmentName(container.getId(), itemId));
        }
        if (fragment != this.currentPrimaryItem) {
            fragment.setMenuVisibility(false);
            fragment.setUserVisibleHint(false);
        }
        return fragment;
    }

    public void destroyItem(ViewGroup container, int position, Object object) {
        if (object instanceof CameraPreviewFragment) {
            return;
        }
        this.verifyTransactionCreated();
        this.currentTransaction.remove((Fragment)object);
    }

    private void verifyTransactionCreated() {
        if (this.currentTransaction == null) {
            this.currentTransaction = this.fragmentManager.beginTransaction();
        }
    }

    public void finishUpdate(ViewGroup container) {
        if (this.currentTransaction != null) {
            this.currentTransaction.commitAllowingStateLoss();
            this.currentTransaction = null;
            this.fragmentManager.executePendingTransactions();
        }
    }

    public boolean isViewFromObject(View view, Object object) {
        return ((Fragment)object).getView() == view;
    }

    public int getCount() {
        return this.documentDraft.size() + 1;
    }

    public int getPagesCount() {
        return this.documentDraft.size();
    }

    public float getPageWidth(int position) {
        return position == this.getCount() - 1 ? 1.0f : 0.7f;
    }

    public void addPage(Page page) {
        this.documentDraft.addPage(page);
        this.notifyDataSetChanged();
    }

    public void addPage(int position, Page page) {
        this.documentDraft.addPage(position, page);
        this.notifyDataSetChanged();
    }

    public void deletePage(int position) {
        this.documentDraft.deletePage(position);
        this.notifyDataSetChanged();
    }

    public void deletePage(Page page) {
        this.documentDraft.deletePage(page);
        this.notifyDataSetChanged();
    }

    public DocumentDraft getDocumentDraft() {
        return this.documentDraft;
    }

    public void setDocumentDraft(DocumentDraft documentDraft) {
        this.documentDraft = documentDraft;
    }

    private static String makeFragmentName(int viewId, long id2) {
        return id2 == 0x7F070007L ? CAMERA_FRAGMENT_TAG : FRAGMENT_TAG_PREFIX + viewId + ":" + id2;
    }
}

