/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.lib.snap.preview.zoom;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.animation.ValueAnimator;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.util.Property;
import android.view.GestureDetector;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import com.google.inject.Inject;
import com.ortiz.touch.TouchImageView;
import net.doo.snap.lib.snap.preview.zoom.PreScaleChangedEvent;
import net.doo.snap.lib.snap.preview.zoom.PrepareZoomEvent;
import net.doo.snap.lib.snap.preview.zoom.QuickScaleEvent;
import net.doo.snap.lib.snap.preview.zoom.StartZoomingEvent;
import net.doo.snap.lib.snap.preview.zoom.ZoomingFinishedEvent;
import net.doo.snap.lib.ui.events.BackPressedEvent;
import net.doo.snap.lib.util.ui.ViewUtils;
import roboguice.event.EventManager;
import roboguice.event.Observes;
import roboguice.fragment.RoboFragment;

public class ZoomedPreviewFragment
extends RoboFragment
implements View.OnTouchListener {
    private static final int MAX_DIM_ALPHA = 230;
    private static final float DEFAULT_SCALE = 1.0f;
    private static final float FINISH_SCALE_THRESHOLD = 1.3f;
    private static final Property<ZoomedPreviewFragment, Float> PRE_SCALE = Property.of(ZoomedPreviewFragment.class, Float.TYPE, (String)"preScale");
    private static final Property<TouchImageView, Float> ZOOM = Property.of(TouchImageView.class, Float.TYPE, (String)"zoom");
    @Inject
    private EventManager eventManager;
    private TouchImageView imageView;
    private ColorDrawable background;
    private boolean zooming = false;
    private boolean scaleCanceled = false;
    private float initialScale;
    private float preScale;
    private Object token;
    private ValueAnimator.AnimatorUpdateListener backgroundUpdater = new ValueAnimator.AnimatorUpdateListener(){

        public void onAnimationUpdate(ValueAnimator valueAnimator) {
            ZoomedPreviewFragment.this.updateBackground(ZoomedPreviewFragment.this.imageView.getZoom());
        }
    };
    private int initialOffsetX;
    private int initialOffsetY;

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(2130903061, container, false);
        this.imageView = (TouchImageView)view.findViewById(2131165195);
        this.imageView.setOnTouchListener(this);
        this.imageView.setOnDoubleTapListener(new GestureDetector.OnDoubleTapListener(){

            public boolean onSingleTapConfirmed(MotionEvent event) {
                return true;
            }

            public boolean onDoubleTap(MotionEvent event) {
                if (ZoomedPreviewFragment.this.imageView.getZoom() > 1.0f) {
                    ZoomedPreviewFragment.this.imageView.animateZoomTo(1.0f);
                } else {
                    ZoomedPreviewFragment.this.imageView.animateZoomTo(ZoomedPreviewFragment.this.imageView.getMaxZoom(), event.getX(), event.getY());
                }
                return true;
            }

            public boolean onDoubleTapEvent(MotionEvent event) {
                return false;
            }
        });
        this.background = (ColorDrawable)this.getResources().getDrawable(2131230737);
        this.background.setAlpha(0);
        view.setBackgroundDrawable((Drawable)this.background);
        view.setLayerType(2, null);
        return view;
    }

    public void onPrepareZooming(@Observes PrepareZoomEvent event) {
        Drawable drawable2 = event.getDrawable();
        Matrix matrix = new Matrix();
        float[] m = new float[9];
        RectF image = new RectF(0.0f, 0.0f, (float)drawable2.getIntrinsicWidth(), (float)drawable2.getIntrinsicHeight());
        RectF upscaled = new RectF(0.0f, 0.0f, (float)this.getView().getWidth(), (float)this.getView().getHeight());
        matrix.setRectToRect(image, upscaled, Matrix.ScaleToFit.START);
        matrix.mapRect(image);
        matrix.reset();
        Rect containerBounds = event.getInitialBounds();
        RectF original = new RectF(0.0f, 0.0f, (float)containerBounds.width(), (float)containerBounds.height());
        matrix.setRectToRect(image, original, Matrix.ScaleToFit.START);
        matrix.getValues(m);
        this.initialScale = Math.min(m[0], m[4]);
        Rect upscaledContainer = ViewUtils.getViewBounds(this.getView());
        this.initialOffsetX = containerBounds.centerX() - upscaledContainer.centerX();
        this.initialOffsetY = containerBounds.centerY() - upscaledContainer.centerY();
        this.imageView.setTranslationX(this.initialOffsetX);
        this.imageView.setTranslationY(this.initialOffsetY);
        this.imageView.animate().translationX(0.0f).translationY(0.0f).start();
        this.imageView.setImageDrawable(drawable2);
        this.imageView.setZoom(1.0f);
        this.imageView.setMinZoom(this.initialScale);
        this.setPreScale(this.initialScale);
        this.token = event.getToken();
    }

    public void onPreScaleChanged(@Observes PreScaleChangedEvent preScaleChangedEvent) {
        float scale = this.initialScale * preScaleChangedEvent.scale;
        this.setPreScale(scale);
    }

    public void onZoomingStarted(@Observes StartZoomingEvent startZoomingEvent) {
        this.zooming = true;
        if (this.preScale > 1.0f) {
            this.imageView.setZoom(this.preScale);
            this.setPreScale(1.0f);
        }
        this.updatePreScaleState();
    }

    public void onQuickScale(@Observes QuickScaleEvent event) {
        this.zooming = true;
        this.resetPreScale();
    }

    private void updatePreScaleState() {
        if (this.preScale < Math.min(1.0f, this.initialScale * 1.3f)) {
            this.cancelPreScale();
        } else if (this.preScale < 1.0f) {
            this.resetPreScale();
        }
    }

    private void resetPreScale() {
        ObjectAnimator.ofFloat((Object)((Object)this), PRE_SCALE, (float[])new float[]{1.0f}).start();
    }

    private void cancelPreScale() {
        this.scaleCanceled = true;
        ObjectAnimator animator2 = ObjectAnimator.ofFloat((Object)((Object)this), PRE_SCALE, (float[])new float[]{this.initialScale});
        animator2.addListener((Animator.AnimatorListener)new ViewUtils.DefaultAnimationListener(){

            @Override
            public void onAnimationFinished(Animator animator2) {
                ZoomedPreviewFragment.this.finish();
            }
        });
        animator2.start();
        this.animateToInitialOffset();
    }

    public void setPreScale(float scale) {
        this.preScale = scale;
        this.imageView.setScaleX(scale);
        this.imageView.setScaleY(scale);
        this.updateBackground(scale);
    }

    public float getPreScale() {
        return this.preScale;
    }

    public boolean onTouch(View view, MotionEvent event) {
        if (this.imageView.getDrawable() == null || !this.zooming || this.scaleCanceled) {
            return true;
        }
        int action = event.getAction();
        float zoom = this.imageView.getZoom();
        if (action == 3 || action == 1) {
            this.updateScaleState(zoom);
        }
        this.updateBackground(zoom);
        return false;
    }

    private void updateScaleState(float scale) {
        if (scale < Math.min(this.initialScale * 1.3f, 1.0f)) {
            this.cancelScale();
        } else if (scale < 1.0f) {
            this.resetScale();
        }
    }

    private void resetScale() {
        ObjectAnimator animator2 = ObjectAnimator.ofFloat((Object)((Object)this.imageView), ZOOM, (float[])new float[]{1.0f});
        animator2.addUpdateListener(this.backgroundUpdater);
        animator2.start();
    }

    private void cancelScale() {
        this.scaleCanceled = true;
        ObjectAnimator animator2 = ObjectAnimator.ofFloat((Object)((Object)this.imageView), ZOOM, (float[])new float[]{this.initialScale});
        animator2.addUpdateListener(this.backgroundUpdater);
        animator2.addListener((Animator.AnimatorListener)new ViewUtils.DefaultAnimationListener(){

            @Override
            public void onAnimationFinished(Animator animator2) {
                ZoomedPreviewFragment.this.finish();
            }
        });
        animator2.start();
        this.animateToInitialOffset();
    }

    private void finish() {
        if (!this.zooming) {
            return;
        }
        this.setPreScale(0.0f);
        this.imageView.setZoom(1.0f);
        this.zooming = false;
        this.scaleCanceled = false;
        this.imageView.setImageDrawable(null);
        this.eventManager.fire((Object)new ZoomingFinishedEvent(this.token));
        this.token = null;
    }

    private void animateToInitialOffset() {
        this.imageView.animate().translationX((float)this.initialOffsetX).translationY((float)this.initialOffsetY).start();
    }

    private void updateBackground(float scale) {
        float fraction = (scale - this.initialScale) / (1.0f - this.initialScale);
        float normalizedFraction = Math.max(Math.min(1.0f, fraction), 0.0f);
        this.background.setAlpha((int)(230.0f * normalizedFraction));
    }

    public void onBackPressed(@Observes BackPressedEvent event) {
        if (this.zooming) {
            this.cancelScale();
        }
    }
}

