/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.java.lazy.types;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotations;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.types.RawSubstitution;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.types.RawTypeImpl;
import kotlin.reflect.jvm.internal.impl.renderer.DescriptorRenderer;
import kotlin.reflect.jvm.internal.impl.renderer.DescriptorRendererOptions;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.MemberScope;
import kotlin.reflect.jvm.internal.impl.types.FlexibleType;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.RawType;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.reflect.jvm.internal.impl.types.checker.KotlinTypeChecker;
import kotlin.reflect.jvm.internal.impl.types.checker.KotlinTypeRefiner;
import kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

public final class RawTypeImpl
extends FlexibleType
implements RawType {
    private RawTypeImpl(SimpleType lowerBound, SimpleType upperBound, boolean disableAssertion) {
        super(lowerBound, upperBound);
        if (!disableAssertion) {
            boolean bl = KotlinTypeChecker.DEFAULT.isSubtypeOf(lowerBound, upperBound);
            boolean bl2 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean bl3 = false;
                String string = "Lower bound " + lowerBound + " of a flexible type must be a subtype of the upper bound " + upperBound;
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
        }
    }

    public RawTypeImpl(@NotNull SimpleType lowerBound, @NotNull SimpleType upperBound) {
        Intrinsics.checkNotNullParameter(lowerBound, "lowerBound");
        Intrinsics.checkNotNullParameter(upperBound, "upperBound");
        this(lowerBound, upperBound, false);
    }

    @Override
    @NotNull
    public SimpleType getDelegate() {
        return this.getLowerBound();
    }

    @Override
    @NotNull
    public MemberScope getMemberScope() {
        Object object;
        Object object2 = this.getConstructor().getDeclarationDescriptor();
        Object object3 = object = object2 instanceof ClassDescriptor ? (ClassDescriptor)object2 : null;
        if (object == null) {
            object2 = Intrinsics.stringPlus("Incorrect classifier: ", this.getConstructor().getDeclarationDescriptor());
            boolean bl = false;
            throw (Throwable)new IllegalStateException(object2.toString());
        }
        ClassDescriptor classDescriptor = object;
        object = classDescriptor.getMemberScope(RawSubstitution.INSTANCE);
        Intrinsics.checkNotNullExpressionValue(object, "classDescriptor.getMemberScope(RawSubstitution)");
        return object;
    }

    @Override
    @NotNull
    public RawTypeImpl replaceAnnotations(@NotNull Annotations newAnnotations) {
        Intrinsics.checkNotNullParameter(newAnnotations, "newAnnotations");
        return new RawTypeImpl(this.getLowerBound().replaceAnnotations(newAnnotations), this.getUpperBound().replaceAnnotations(newAnnotations));
    }

    @Override
    @NotNull
    public RawTypeImpl makeNullableAsSpecified(boolean newNullability) {
        return new RawTypeImpl(this.getLowerBound().makeNullableAsSpecified(newNullability), this.getUpperBound().makeNullableAsSpecified(newNullability));
    }

    @Override
    @NotNull
    public String render(@NotNull DescriptorRenderer renderer, @NotNull DescriptorRendererOptions options2) {
        boolean bl;
        String newArgs2;
        String upperRendered;
        String lowerRendered;
        block6: {
            Intrinsics.checkNotNullParameter(renderer, "renderer");
            Intrinsics.checkNotNullParameter(options2, "options");
            lowerRendered = renderer.renderType(this.getLowerBound());
            upperRendered = renderer.renderType(this.getUpperBound());
            if (options2.getDebugMode()) {
                return "raw (" + lowerRendered + ".." + upperRendered + ')';
            }
            if (this.getUpperBound().getArguments().isEmpty()) {
                return renderer.renderFlexibleType(lowerRendered, upperRendered, TypeUtilsKt.getBuiltIns(this));
            }
            List<String> lowerArgs = RawTypeImpl.render$renderArguments(renderer, this.getLowerBound());
            List<String> upperArgs = RawTypeImpl.render$renderArguments(renderer, this.getUpperBound());
            newArgs2 = CollectionsKt.joinToString$default(lowerArgs, ", ", null, null, 0, null, render.newArgs.1.INSTANCE, 30, null);
            Iterable $this$all$iv = CollectionsKt.zip((Iterable)lowerArgs, (Iterable)upperArgs);
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    Pair it = (Pair)element$iv;
                    boolean bl2 = false;
                    if (RawTypeImpl.render$onlyOutDiffers((String)it.getFirst(), (String)it.getSecond())) continue;
                    bl = false;
                    break block6;
                }
                bl = true;
            }
        }
        String newUpper = bl ? RawTypeImpl.render$replaceArgs(upperRendered, newArgs2) : upperRendered;
        String newLower = RawTypeImpl.render$replaceArgs(lowerRendered, newArgs2);
        if (Intrinsics.areEqual(newLower, newUpper)) {
            return newLower;
        }
        return renderer.renderFlexibleType(newLower, newUpper, TypeUtilsKt.getBuiltIns(this));
    }

    @Override
    @NotNull
    public FlexibleType refine(@NotNull KotlinTypeRefiner kotlinTypeRefiner) {
        Intrinsics.checkNotNullParameter(kotlinTypeRefiner, "kotlinTypeRefiner");
        return new RawTypeImpl((SimpleType)kotlinTypeRefiner.refineType(this.getLowerBound()), (SimpleType)kotlinTypeRefiner.refineType(this.getUpperBound()), true);
    }

    private static final boolean render$onlyOutDiffers(String first2, String second) {
        return Intrinsics.areEqual(first2, StringsKt.removePrefix(second, (CharSequence)"out ")) || Intrinsics.areEqual(second, "*");
    }

    /*
     * WARNING - void declaration
     */
    private static final List<String> render$renderArguments(DescriptorRenderer $renderer, KotlinType type2) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = type2.getArguments();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TypeProjection typeProjection = (TypeProjection)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = $renderer.renderTypeProjection((TypeProjection)it);
            collection.add(string);
        }
        return (List)destination$iv$iv;
    }

    private static final String render$replaceArgs(String $this$render_u24replaceArgs, String newArgs2) {
        if (!StringsKt.contains$default((CharSequence)$this$render_u24replaceArgs, '<', false, 2, null)) {
            return $this$render_u24replaceArgs;
        }
        return StringsKt.substringBefore$default($this$render_u24replaceArgs, '<', null, 2, null) + '<' + newArgs2 + '>' + StringsKt.substringAfterLast$default($this$render_u24replaceArgs, '>', null, 2, null);
    }
}

