/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.lang.jvm.JvmClass;
import com.intellij.lang.jvm.JvmTypeDeclaration;
import com.intellij.lang.jvm.facade.JvmFacade;
import com.intellij.lang.jvm.facade.JvmFacadeImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JvmPsiConversionHelper;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiConstantEvaluationHelper;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementFinder;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiJavaParserFacade;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.impl.IsConstantExpressionVisitor;
import com.intellij.psi.impl.JavaPsiFacadeEx;
import com.intellij.psi.impl.PsiConstantEvaluationHelperImpl;
import com.intellij.psi.impl.file.impl.JavaFileManager;
import com.intellij.psi.impl.source.DummyHolderFactory;
import com.intellij.psi.impl.source.JavaDummyHolder;
import com.intellij.psi.impl.source.JavaDummyHolderFactory;
import com.intellij.psi.impl.source.resolve.FileContextUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaPsiFacadeImpl
extends JavaPsiFacadeEx {
    private static final Logger LOG = Logger.getInstance(JavaPsiFacadeImpl.class);
    private final PsiConstantEvaluationHelper myConstantEvaluationHelper;
    private final ConcurrentMap<String, PsiPackage> myPackageCache = ContainerUtil.createConcurrentSoftValueMap();
    private final ConcurrentMap<GlobalSearchScope, Map<String, PsiClass>> myClassCache = ContainerUtil.createConcurrentSoftKeySoftValueMap();
    private final Map<GlobalSearchScope, Map<String, Collection<PsiJavaModule>>> myModuleCache = ContainerUtil.createConcurrentSoftKeySoftValueMap();
    private final Project myProject;
    private final JavaFileManager myFileManager;
    private final AtomicNotNullLazyValue<JvmFacadeImpl> myJvmFacade;
    private final JvmPsiConversionHelper myConversionHelper;

    public JavaPsiFacadeImpl(Project project) {
        this.myProject = project;
        this.myFileManager = JavaFileManager.getInstance(this.myProject);
        this.myConstantEvaluationHelper = new PsiConstantEvaluationHelperImpl();
        this.myJvmFacade = AtomicNotNullLazyValue.createValue(() -> (JvmFacadeImpl)JvmFacade.getInstance(project));
        this.myConversionHelper = JvmPsiConversionHelper.getInstance(this.myProject);
        project.getMessageBus().connect().subscribe(PsiModificationTracker.TOPIC, () -> {
            this.myClassCache.clear();
            this.myPackageCache.clear();
            this.myModuleCache.clear();
        });
        DummyHolderFactory.setFactory(new JavaDummyHolderFactory());
    }

    @Override
    public PsiClass findClass(@NotNull String qualifiedName2, @NotNull GlobalSearchScope scope2) {
        PsiClass result2;
        if (qualifiedName2 == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(0);
        }
        if (scope2 == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(1);
        }
        ProgressIndicatorProvider.checkCanceled();
        Map<String, PsiClass> map = (ConcurrentMap)this.myClassCache.get(scope2);
        if (map == null) {
            map = ContainerUtil.createConcurrentWeakValueMap();
            map = ConcurrencyUtil.cacheOrGet(this.myClassCache, scope2, map);
        }
        if ((result2 = (PsiClass)map.get(qualifiedName2)) == null && (result2 = this.doFindClass(qualifiedName2, scope2)) != null) {
            map.put(qualifiedName2, result2);
        }
        return result2;
    }

    @Nullable
    private PsiClass doFindClass(@NotNull String qualifiedName2, @NotNull GlobalSearchScope scope2) {
        if (qualifiedName2 == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(2);
        }
        if (scope2 == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(3);
        }
        if (this.shouldUseSlowResolve()) {
            PsiClass[] classes2 = this.findClassesInDumbMode(qualifiedName2, scope2);
            if (classes2.length != 0) {
                return classes2[0];
            }
            return null;
        }
        List<PsiElementFinder> finders = this.filteredFinders();
        Condition<PsiClass> classesFilter = JavaPsiFacadeImpl.getFilterFromFinders(scope2, finders);
        for (PsiElementFinder finder : finders) {
            PsiClass aClass2 = finder.findClass(qualifiedName2, scope2);
            if (aClass2 == null || classesFilter != null && !classesFilter.value(aClass2)) continue;
            return aClass2;
        }
        return null;
    }

    private PsiClass @NotNull [] findClassesInDumbMode(@NotNull String qualifiedName2, @NotNull GlobalSearchScope scope2) {
        if (qualifiedName2 == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(4);
        }
        if (scope2 == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(5);
        }
        String packageName = StringUtil.getPackageName(qualifiedName2);
        PsiPackage pkg = this.findPackage(packageName);
        String className2 = StringUtil.getShortName(qualifiedName2);
        if (pkg == null && packageName.length() < qualifiedName2.length()) {
            PsiClass[] containingClasses = this.findClassesInDumbMode(packageName, scope2);
            if (containingClasses.length == 1) {
                PsiClass[] psiClassArray = PsiElementFinder.filterByName(className2, containingClasses[0].getInnerClasses());
                if (psiClassArray == null) {
                    JavaPsiFacadeImpl.$$$reportNull$$$0(6);
                }
                return psiClassArray;
            }
            if (PsiClass.EMPTY_ARRAY == null) {
                JavaPsiFacadeImpl.$$$reportNull$$$0(7);
            }
            return PsiClass.EMPTY_ARRAY;
        }
        if (pkg == null) {
            if (PsiClass.EMPTY_ARRAY == null) {
                JavaPsiFacadeImpl.$$$reportNull$$$0(8);
            }
            return PsiClass.EMPTY_ARRAY;
        }
        PsiClass[] psiClassArray = pkg.findClassByShortName(className2, scope2);
        if (psiClassArray == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(9);
        }
        return psiClassArray;
    }

    @Override
    public PsiClass @NotNull [] findClasses(@NotNull String qualifiedName2, @NotNull GlobalSearchScope scope2) {
        List<PsiClass> allClasses;
        if (qualifiedName2 == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(10);
        }
        if (scope2 == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(11);
        }
        PsiClass[] psiClassArray = (allClasses = this.findClassesWithJvmFacade(qualifiedName2, scope2)).isEmpty() ? PsiClass.EMPTY_ARRAY : allClasses.toArray(PsiClass.EMPTY_ARRAY);
        if (psiClassArray == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(12);
        }
        return psiClassArray;
    }

    @NotNull
    private List<PsiClass> findClassesWithJvmFacade(@NotNull String qualifiedName2, @NotNull GlobalSearchScope scope2) {
        List<JvmClass> jvmClasses;
        if (qualifiedName2 == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(13);
        }
        if (scope2 == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(14);
        }
        ArrayList<PsiClass> result2 = null;
        List<PsiClass> ownClasses = this.findClassesWithoutJvmFacade(qualifiedName2, scope2);
        if (!ownClasses.isEmpty()) {
            result2 = new ArrayList<PsiClass>(ownClasses);
        }
        if (!(jvmClasses = this.myJvmFacade.getValue().findClassesWithoutJavaFacade(qualifiedName2, scope2)).isEmpty()) {
            List<PsiClass> jvmPsiClasses = ContainerUtil.map(jvmClasses, it -> this.myConversionHelper.convertTypeDeclaration((JvmTypeDeclaration)it));
            if (result2 == null) {
                result2 = new ArrayList<PsiClass>(jvmPsiClasses);
            } else {
                result2.addAll(jvmPsiClasses);
            }
        }
        List<PsiClass> list2 = result2 == null ? Collections.emptyList() : result2;
        if (list2 == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(15);
        }
        return list2;
    }

    @NotNull
    public List<PsiClass> findClassesWithoutJvmFacade(@NotNull String qualifiedName2, @NotNull GlobalSearchScope scope2) {
        if (qualifiedName2 == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(16);
        }
        if (scope2 == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(17);
        }
        if (this.shouldUseSlowResolve()) {
            List<PsiClass> list2 = Arrays.asList(this.findClassesInDumbMode(qualifiedName2, scope2));
            if (list2 == null) {
                JavaPsiFacadeImpl.$$$reportNull$$$0(18);
            }
            return list2;
        }
        List<PsiElementFinder> finders = this.filteredFinders();
        Condition<PsiClass> classesFilter = JavaPsiFacadeImpl.getFilterFromFinders(scope2, finders);
        ArrayList result2 = null;
        for (PsiElementFinder finder : finders) {
            PsiClass[] finderClasses = finder.findClasses(qualifiedName2, scope2);
            if (finderClasses.length == 0) continue;
            if (result2 == null) {
                result2 = new ArrayList(finderClasses.length);
            }
            JavaPsiFacadeImpl.filterClassesAndAppend(finder, classesFilter, finderClasses, result2);
        }
        List<PsiClass> list3 = result2 == null ? Collections.emptyList() : result2;
        if (list3 == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(19);
        }
        return list3;
    }

    private static Condition<PsiClass> getFilterFromFinders(@NotNull GlobalSearchScope scope2, @NotNull List<PsiElementFinder> finders) {
        if (scope2 == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(20);
        }
        if (finders == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(21);
        }
        Condition<PsiClass> filter2 = null;
        for (PsiElementFinder finder : finders) {
            Condition<PsiClass> finderFilter = finder.getClassesFilter(scope2);
            if (finderFilter == null) continue;
            filter2 = filter2 == null ? finderFilter : Conditions.and(filter2, finderFilter);
        }
        return filter2;
    }

    private boolean shouldUseSlowResolve() {
        DumbService dumbService = DumbService.getInstance(this.getProject());
        return dumbService.isDumb() && dumbService.isAlternativeResolveEnabled();
    }

    @Override
    @NotNull
    public PsiConstantEvaluationHelper getConstantEvaluationHelper() {
        PsiConstantEvaluationHelper psiConstantEvaluationHelper = this.myConstantEvaluationHelper;
        if (psiConstantEvaluationHelper == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(22);
        }
        return psiConstantEvaluationHelper;
    }

    @Override
    public PsiPackage findPackage(@NotNull String qualifiedName2) {
        PsiPackage aPackage;
        if (qualifiedName2 == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(23);
        }
        if ((aPackage = (PsiPackage)this.myPackageCache.get(qualifiedName2)) != null) {
            return aPackage;
        }
        for (PsiElementFinder finder : this.filteredFinders()) {
            aPackage = finder.findPackage(qualifiedName2);
            if (aPackage == null) continue;
            return ConcurrencyUtil.cacheOrGet(this.myPackageCache, qualifiedName2, aPackage);
        }
        return null;
    }

    @Override
    public PsiJavaModule findModule(@NotNull String moduleName, @NotNull GlobalSearchScope scope2) {
        Collection<PsiJavaModule> modules;
        if (moduleName == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(24);
        }
        if (scope2 == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(25);
        }
        return (modules = this.findModules(moduleName, scope2)).size() == 1 ? modules.iterator().next() : null;
    }

    @Override
    @NotNull
    public Collection<PsiJavaModule> findModules(@NotNull String moduleName, @NotNull GlobalSearchScope scope2) {
        if (moduleName == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(26);
        }
        if (scope2 == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(27);
        }
        Collection collection = this.myModuleCache.computeIfAbsent(scope2, k -> ContainerUtil.createConcurrentWeakValueMap()).computeIfAbsent(moduleName, k -> JavaFileManager.getInstance(this.myProject).findModules((String)k, scope2));
        if (collection == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(28);
        }
        return collection;
    }

    @NotNull
    private List<PsiElementFinder> filteredFinders() {
        List<PsiElementFinder> list2 = DumbService.getInstance(this.getProject()).filterByDumbAwareness(PsiElementFinder.EP.getPoint(this.myProject).getExtensionList());
        if (list2 == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(29);
        }
        return list2;
    }

    @Override
    @NotNull
    public PsiJavaParserFacade getParserFacade() {
        PsiElementFactory psiElementFactory = this.getElementFactory();
        if (psiElementFactory == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(30);
        }
        return psiElementFactory;
    }

    @Override
    @NotNull
    public PsiResolveHelper getResolveHelper() {
        PsiResolveHelper psiResolveHelper = PsiResolveHelper.SERVICE.getInstance(this.myProject);
        if (psiResolveHelper == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(31);
        }
        return psiResolveHelper;
    }

    @Override
    @NotNull
    public PsiNameHelper getNameHelper() {
        PsiNameHelper psiNameHelper = PsiNameHelper.getInstance(this.myProject);
        if (psiNameHelper == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(32);
        }
        return psiNameHelper;
    }

    @NotNull
    public Set<String> getClassNames(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope2) {
        if (psiPackage == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(33);
        }
        if (scope2 == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(34);
        }
        THashSet<String> result2 = new THashSet<String>();
        for (PsiElementFinder finder : this.filteredFinders()) {
            result2.addAll(finder.getClassNames(psiPackage, scope2));
        }
        THashSet<String> tHashSet = result2;
        if (tHashSet == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(35);
        }
        return tHashSet;
    }

    public PsiClass @NotNull [] getClasses(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope2) {
        if (psiPackage == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(36);
        }
        if (scope2 == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(37);
        }
        List<PsiElementFinder> finders = this.filteredFinders();
        Condition<PsiClass> classesFilter = JavaPsiFacadeImpl.getFilterFromFinders(scope2, finders);
        ArrayList result2 = null;
        for (PsiElementFinder finder : finders) {
            PsiClass[] classes2 = finder.getClasses(psiPackage, scope2);
            if (classes2.length == 0) continue;
            if (result2 == null) {
                result2 = new ArrayList(classes2.length);
            }
            JavaPsiFacadeImpl.filterClassesAndAppend(finder, classesFilter, classes2, result2);
        }
        PsiClass[] psiClassArray = result2 == null ? PsiClass.EMPTY_ARRAY : result2.toArray(PsiClass.EMPTY_ARRAY);
        if (psiClassArray == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(38);
        }
        return psiClassArray;
    }

    private static void filterClassesAndAppend(PsiElementFinder finder, @Nullable Condition<? super PsiClass> classesFilter, PsiClass @NotNull [] classes2, @NotNull List<? super PsiClass> result2) {
        if (result2 == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(39);
        }
        if (classes2 == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(40);
        }
        for (PsiClass psiClass : classes2) {
            if (psiClass == null) {
                LOG.error("Finder " + finder + " returned null PsiClass");
                continue;
            }
            if (classesFilter != null && !classesFilter.value(psiClass)) continue;
            result2.add(psiClass);
        }
    }

    public PsiFile @NotNull [] getPackageFiles(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope2) {
        if (psiPackage == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(41);
        }
        if (scope2 == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(42);
        }
        Condition<PsiFile> filter2 = null;
        for (PsiElementFinder finder : this.filteredFinders()) {
            Condition<PsiFile> finderFilter = finder.getPackageFilesFilter(psiPackage, scope2);
            if (finderFilter == null) continue;
            if (filter2 == null) {
                filter2 = finderFilter;
                continue;
            }
            filter2 = Conditions.and(filter2, finderFilter);
        }
        LinkedHashSet<PsiFile> result2 = new LinkedHashSet<PsiFile>();
        PsiDirectory[] directories2 = psiPackage.getDirectories(scope2);
        for (PsiDirectory directory : directories2) {
            for (PsiFile file2 : directory.getFiles()) {
                if (filter2 != null && !filter2.value(file2)) continue;
                result2.add(file2);
            }
        }
        for (PsiElementFinder finder : this.filteredFinders()) {
            Collections.addAll(result2, finder.getPackageFiles(psiPackage, scope2));
        }
        PsiFile[] psiFileArray = result2.toArray(PsiFile.EMPTY_ARRAY);
        if (psiFileArray == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(43);
        }
        return psiFileArray;
    }

    public boolean processPackageDirectories(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope2, @NotNull Processor<? super PsiDirectory> consumer, boolean includeLibrarySources) {
        if (psiPackage == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(44);
        }
        if (scope2 == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(45);
        }
        if (consumer == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(46);
        }
        for (PsiElementFinder finder : this.filteredFinders()) {
            if (finder.processPackageDirectories(psiPackage, scope2, consumer, includeLibrarySources)) continue;
            return false;
        }
        return true;
    }

    public PsiPackage @NotNull [] getSubPackages(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope2) {
        if (psiPackage == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(47);
        }
        if (scope2 == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(48);
        }
        LinkedHashMap<String, PsiPackage> result2 = new LinkedHashMap<String, PsiPackage>();
        for (PsiElementFinder finder : this.filteredFinders()) {
            PsiPackage[] packages2;
            for (PsiPackage aPackage : packages2 = finder.getSubPackages(psiPackage, scope2)) {
                result2.putIfAbsent(aPackage.getName(), aPackage);
            }
        }
        PsiPackage[] psiPackageArray = result2.values().toArray(PsiPackage.EMPTY_ARRAY);
        if (psiPackageArray == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(49);
        }
        return psiPackageArray;
    }

    @Override
    public boolean isPartOfPackagePrefix(@NotNull String packageName) {
        if (packageName == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(50);
        }
        Collection<String> packagePrefixes = this.myFileManager.getNonTrivialPackagePrefixes();
        for (String subpackageName : packagePrefixes) {
            if (!PsiNameHelper.isSubpackageOf(subpackageName, packageName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isInPackage(@NotNull PsiElement element, @NotNull PsiPackage aPackage) {
        PsiFile file2;
        if (element == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(51);
        }
        if (aPackage == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(52);
        }
        if ((file2 = FileContextUtil.getContextFile(element)) instanceof JavaDummyHolder) {
            return ((JavaDummyHolder)file2).isInPackage(aPackage);
        }
        if (file2 instanceof PsiJavaFile) {
            String packageName = ((PsiJavaFile)file2).getPackageName();
            return packageName.equals(aPackage.getQualifiedName());
        }
        return false;
    }

    @Override
    public boolean arePackagesTheSame(@NotNull PsiElement element1, @NotNull PsiElement element2) {
        PsiFile file2;
        PsiFile file1;
        if (element1 == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(53);
        }
        if (element2 == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(54);
        }
        if (Comparing.equal(file1 = FileContextUtil.getContextFile(element1), file2 = FileContextUtil.getContextFile(element2))) {
            return true;
        }
        if (file1 instanceof JavaDummyHolder && file2 instanceof JavaDummyHolder) {
            return true;
        }
        if (file1 instanceof JavaDummyHolder || file2 instanceof JavaDummyHolder) {
            JavaDummyHolder dummyHolder = (JavaDummyHolder)(file1 instanceof JavaDummyHolder ? file1 : file2);
            PsiFile other = file1 instanceof JavaDummyHolder ? file2 : file1;
            return dummyHolder.isSamePackage(other);
        }
        if (!(file1 instanceof PsiClassOwner)) {
            return false;
        }
        if (!(file2 instanceof PsiClassOwner)) {
            return false;
        }
        String package1 = ((PsiClassOwner)file1).getPackageName();
        String package2 = ((PsiClassOwner)file2).getPackageName();
        return Objects.equals(package1, package2);
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(55);
        }
        return project;
    }

    @Override
    public boolean isConstantExpression(@NotNull PsiExpression expression2) {
        if (expression2 == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(56);
        }
        IsConstantExpressionVisitor visitor2 = new IsConstantExpressionVisitor();
        expression2.accept(visitor2);
        return visitor2.isConstant();
    }

    @Override
    @NotNull
    public PsiElementFactory getElementFactory() {
        PsiElementFactory psiElementFactory = PsiElementFactory.getInstance(this.myProject);
        if (psiElementFactory == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(57);
        }
        return psiElementFactory;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 15: 
            case 18: 
            case 19: 
            case 22: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 35: 
            case 38: 
            case 43: 
            case 49: 
            case 55: 
            case 57: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 15: 
            case 18: 
            case 19: 
            case 22: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 35: 
            case 38: 
            case 43: 
            case 49: 
            case 55: 
            case 57: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 11: 
            case 14: 
            case 17: 
            case 20: 
            case 25: 
            case 27: 
            case 34: 
            case 37: 
            case 42: 
            case 45: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 15: 
            case 18: 
            case 19: 
            case 22: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 35: 
            case 38: 
            case 43: 
            case 49: 
            case 55: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/JavaPsiFacadeImpl";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "finders";
                break;
            }
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
            case 33: 
            case 36: 
            case 41: 
            case 44: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiPackage";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classes";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aPackage";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element1";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element2";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/JavaPsiFacadeImpl";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "findClassesInDumbMode";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "findClasses";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "findClassesWithJvmFacade";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "findClassesWithoutJvmFacade";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getConstantEvaluationHelper";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "findModules";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "filteredFinders";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getParserFacade";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolveHelper";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameHelper";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassNames";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getClasses";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageFiles";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubPackages";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findClass";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doFindClass";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findClassesInDumbMode";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 15: 
            case 18: 
            case 19: 
            case 22: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 35: 
            case 38: 
            case 43: 
            case 49: 
            case 55: 
            case 57: {
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findClasses";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findClassesWithJvmFacade";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "findClassesWithoutJvmFacade";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getFilterFromFinders";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "findPackage";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "findModule";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "findModules";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getClassNames";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getClasses";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "filterClassesAndAppend";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getPackageFiles";
                break;
            }
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "processPackageDirectories";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getSubPackages";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "isPartOfPackagePrefix";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "isInPackage";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "arePackagesTheSame";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "isConstantExpression";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 15: 
            case 18: 
            case 19: 
            case 22: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 35: 
            case 38: 
            case 43: 
            case 49: 
            case 55: 
            case 57: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

