/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental;

import com.intellij.util.io.DataExternalizer;
import java.io.DataInput;
import java.io.DataOutput;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.incremental.js.TranslationResultValue;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/incremental/TranslationResultValueExternalizer;", "Lcom/intellij/util/io/DataExternalizer;", "Lorg/jetbrains/kotlin/incremental/js/TranslationResultValue;", "()V", "read", "input", "Ljava/io/DataInput;", "save", "", "output", "Ljava/io/DataOutput;", "value", "kotlin-build-common"})
final class TranslationResultValueExternalizer
implements DataExternalizer<TranslationResultValue> {
    @NotNull
    public static final TranslationResultValueExternalizer INSTANCE = new TranslationResultValueExternalizer();

    private TranslationResultValueExternalizer() {
    }

    @Override
    public void save(@NotNull DataOutput output, @NotNull TranslationResultValue value2) {
        Intrinsics.checkNotNullParameter(output, "output");
        Intrinsics.checkNotNullParameter(value2, "value");
        output.writeInt(value2.getMetadata().length);
        output.write(value2.getMetadata());
        output.writeInt(value2.getBinaryAst().length);
        output.write(value2.getBinaryAst());
        output.writeInt(value2.getInlineData().length);
        output.write(value2.getInlineData());
    }

    @Override
    @NotNull
    public TranslationResultValue read(@NotNull DataInput input) {
        Intrinsics.checkNotNullParameter(input, "input");
        int metadataSize = input.readInt();
        byte[] metadata2 = new byte[metadataSize];
        input.readFully(metadata2);
        int binaryAstSize = input.readInt();
        byte[] binaryAst = new byte[binaryAstSize];
        input.readFully(binaryAst);
        int inlineDataSize = input.readInt();
        byte[] inlineData = new byte[inlineDataSize];
        input.readFully(inlineData);
        return new TranslationResultValue(metadata2, binaryAst, inlineData);
    }
}

