/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.interpreter.state;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.interpreter.state.Primitive;
import org.jetbrains.kotlin.ir.interpreter.state.State;
import org.jetbrains.kotlin.ir.interpreter.state.StateKt;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrStarProjection;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeArgument;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0002\b\u0004\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0000\u001a\u0013\u0010\u0003\u001a\u0004\u0018\u00010\u0001*\u00020\u0002H\u0000\u00a2\u0006\u0002\u0010\u0004\u001a\f\u0010\u0005\u001a\u00020\u0006*\u00020\u0002H\u0000\u001a\f\u0010\u0007\u001a\u00020\b*\u00020\u0002H\u0000\u001a&\u0010\t\u001a\u00020\u0002*\u00020\u00022\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u000e\b\u0002\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0000\u001a\f\u0010\u000f\u001a\u00020\u0001*\u00020\u0002H\u0000\u001a\u0014\u0010\u0010\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u000bH\u0000\u00a8\u0006\u0012"}, d2={"asBoolean", "", "Lorg/jetbrains/kotlin/ir/interpreter/state/State;", "asBooleanOrNull", "(Lorg/jetbrains/kotlin/ir/interpreter/state/State;)Ljava/lang/Boolean;", "asInt", "", "asString", "", "checkNullability", "irType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "throwException", "Lkotlin/Function0;", "", "isNull", "isSubtypeOf", "other", "ir.interpreter"})
public final class StateKt {
    public static final boolean isNull(@NotNull State $this$isNull) {
        Intrinsics.checkNotNullParameter($this$isNull, "<this>");
        return $this$isNull instanceof Primitive && ((Primitive)$this$isNull).getValue() == null;
    }

    public static final int asInt(@NotNull State $this$asInt) {
        Intrinsics.checkNotNullParameter($this$asInt, "<this>");
        Object t = ((Primitive)$this$asInt).getValue();
        if (t == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
        }
        return (Integer)t;
    }

    public static final boolean asBoolean(@NotNull State $this$asBoolean) {
        Intrinsics.checkNotNullParameter($this$asBoolean, "<this>");
        Object t = ((Primitive)$this$asBoolean).getValue();
        if (t == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Boolean");
        }
        return (Boolean)t;
    }

    @NotNull
    public static final String asString(@NotNull State $this$asString) {
        Intrinsics.checkNotNullParameter($this$asString, "<this>");
        return String.valueOf(((Primitive)$this$asString).getValue());
    }

    @Nullable
    public static final Boolean asBooleanOrNull(@NotNull State $this$asBooleanOrNull) {
        Intrinsics.checkNotNullParameter($this$asBooleanOrNull, "<this>");
        Primitive primitive = $this$asBooleanOrNull instanceof Primitive ? (Primitive)$this$asBooleanOrNull : null;
        Object var1_2 = primitive == null ? null : primitive.getValue();
        return var1_2 instanceof Boolean ? (Boolean)var1_2 : null;
    }

    public static final boolean isSubtypeOf(@NotNull State $this$isSubtypeOf, @NotNull IrType other) {
        Intrinsics.checkNotNullParameter($this$isSubtypeOf, "<this>");
        Intrinsics.checkNotNullParameter(other, "other");
        if ($this$isSubtypeOf instanceof Primitive && ((Primitive)$this$isSubtypeOf).getValue() == null) {
            return IrTypeUtilsKt.isNullable(other);
        }
        if ($this$isSubtypeOf instanceof Primitive && IrTypePredicatesKt.isArray(((Primitive)$this$isSubtypeOf).getType()) && IrTypePredicatesKt.isArray(other)) {
            IrClassSymbol thisClass = (IrClassSymbol)CollectionsKt.single($this$isSubtypeOf.getTypeArguments()).getState().getIrClass().getSymbol();
            IrTypeArgument otherArgument = CollectionsKt.single(((IrSimpleType)other).getArguments());
            if (otherArgument instanceof IrStarProjection) {
                return true;
            }
            IrClassifierSymbol irClassifierSymbol = thisClass;
            IrType irType = IrTypesKt.getTypeOrNull(otherArgument);
            Intrinsics.checkNotNull(irType);
            IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull(irType);
            Intrinsics.checkNotNull(irClassSymbol);
            return IrTypeUtilsKt.isSubtypeOfClass(irClassifierSymbol, irClassSymbol);
        }
        IrType irType = IrUtilsKt.getDefaultType($this$isSubtypeOf.getIrClass());
        IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull(other);
        Intrinsics.checkNotNull(irClassSymbol);
        return IrTypeUtilsKt.isSubtypeOfClass(irType, irClassSymbol);
    }

    @NotNull
    public static final State checkNullability(@NotNull State $this$checkNullability, @Nullable IrType irType, @NotNull Function0 throwException) {
        Intrinsics.checkNotNullParameter($this$checkNullability, "<this>");
        Intrinsics.checkNotNullParameter(throwException, "throwException");
        if (!(irType instanceof IrSimpleType)) {
            return $this$checkNullability;
        }
        if (StateKt.isNull($this$checkNullability) && !IrTypeUtilsKt.isNullable(irType)) {
            throwException.invoke();
            throw null;
        }
        return $this$checkNullability;
    }

    public static /* synthetic */ State checkNullability$default(State state, IrType irType, Function0 function0, int n, Object object) {
        if ((n & 2) != 0) {
            function0 = checkNullability.1.INSTANCE;
        }
        return StateKt.checkNullability(state, irType, function0);
    }
}

