/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.DeclarationTransformer;
import org.jetbrains.kotlin.backend.common.Mapping;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.impl.IrErrorExpressionImpl;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000e2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\n\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/DefaultParameterCleaner;", "Lorg/jetbrains/kotlin/backend/common/DeclarationTransformer;", "context", "Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "replaceDefaultValuesWithStubs", "", "(Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;Z)V", "getContext", "()Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "getReplaceDefaultValuesWithStubs", "()Z", "withLocalDeclarations", "getWithLocalDeclarations", "transformFlat", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "declaration", "ir.backend.common"})
public final class DefaultParameterCleaner
implements DeclarationTransformer {
    @NotNull
    private final CommonBackendContext context;
    private final boolean replaceDefaultValuesWithStubs;

    public DefaultParameterCleaner(@NotNull CommonBackendContext context, boolean replaceDefaultValuesWithStubs) {
        Intrinsics.checkNotNullParameter(context, "context");
        this.context = context;
        this.replaceDefaultValuesWithStubs = replaceDefaultValuesWithStubs;
    }

    public /* synthetic */ DefaultParameterCleaner(CommonBackendContext commonBackendContext, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(commonBackendContext, bl);
    }

    @NotNull
    public final CommonBackendContext getContext() {
        return this.context;
    }

    public final boolean getReplaceDefaultValuesWithStubs() {
        return this.replaceDefaultValuesWithStubs;
    }

    @Override
    public boolean getWithLocalDeclarations() {
        return true;
    }

    @Override
    @Nullable
    public List<IrDeclaration> transformFlat(@NotNull IrDeclaration declaration) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        if (declaration instanceof IrValueParameter && ((IrValueParameter)declaration).getDefaultValue() != null) {
            if (this.replaceDefaultValuesWithStubs) {
                Mapping.Delegate<IrFunction, IrFunction> delegate2 = this.context.getMapping().getDefaultArgumentsOriginalFunction();
                IrDeclarationParent irDeclarationParent = declaration.getParent();
                Intrinsics.checkNotNull(irDeclarationParent, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrFunction");
                if (delegate2.get((IrFunction)((IrDeclaration)((IrFunction)irDeclarationParent))) == null) {
                    ((IrValueParameter)declaration).setDefaultValue(this.context.getIrFactory().createExpressionBody(new IrErrorExpressionImpl(-1, -1, ((IrValueParameter)declaration).getType(), "Default Stub")));
                }
            } else {
                ((IrValueParameter)declaration).setDefaultValue(null);
            }
        }
        return null;
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        DeclarationTransformer.DefaultImpls.lower(this, irFile);
    }
}

