/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.optimization.common.BackwardAnalysisInterpreter;
import org.jetbrains.kotlin.codegen.optimization.common.ControlFlowGraph;
import org.jetbrains.kotlin.codegen.optimization.common.VarFrame;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.InsnList;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a2\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u000e\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0007\u00a8\u0006\b"}, d2={"analyze", "", "F", "Lorg/jetbrains/kotlin/codegen/optimization/common/VarFrame;", "node", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "interpreter", "Lorg/jetbrains/kotlin/codegen/optimization/common/BackwardAnalysisInterpreter;", "backend"})
public final class BackwardAnalysisKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <F extends VarFrame<F>> List<F> analyze(@NotNull MethodNode node, @NotNull BackwardAnalysisInterpreter<F> interpreter2) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(node, "node");
        Intrinsics.checkNotNullParameter(interpreter2, "interpreter");
        ControlFlowGraph graph2 = ControlFlowGraph.Companion.build$default(ControlFlowGraph.Companion, node, false, 2, null);
        InsnList insnList = node.instructions;
        Iterable $this$map$iv = new IntRange(1, insnList.size());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(interpreter2.newFrame(node.maxLocals));
        }
        List frames = CollectionsKt.toMutableList((List)destination$iv$iv);
        AbstractInsnNode[] insnArray = insnList.toArray();
        boolean wereChanges = false;
        do {
            wereChanges = false;
            int n = insnArray.length + -1;
            if (0 > n) continue;
            do {
                int index2 = n--;
                AbstractInsnNode insn = insnArray[index2];
                VarFrame newFrame2 = interpreter2.newFrame(node.maxLocals);
                Intrinsics.checkNotNullExpressionValue(insn, "insn");
                Iterator<Integer> iterator3 = graph2.getSuccessorsIndices(insn).iterator();
                while (iterator3.hasNext()) {
                    int successorIndex = ((Number)iterator3.next()).intValue();
                    newFrame2.mergeFrom((VarFrame)((VarFrame)frames.get(successorIndex)));
                }
                if (graph2.getPredecessorsIndices(insn).size() > 1) {
                    newFrame2.markControlFlowMerge();
                }
                interpreter2.def(newFrame2, insn);
                interpreter2.use(newFrame2, insn);
                if (Intrinsics.areEqual(frames.get(index2), newFrame2)) continue;
                frames.set(index2, newFrame2);
                wereChanges = true;
            } while (0 <= n);
        } while (wereChanges);
        return frames;
    }
}

