/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization.fixStack;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.inline.InlineCodegenUtilsKt;
import org.jetbrains.kotlin.codegen.optimization.common.InsnSequence;
import org.jetbrains.kotlin.codegen.optimization.fixStack.FixStackAnalyzer;
import org.jetbrains.kotlin.codegen.optimization.fixStack.FixStackContext;
import org.jetbrains.kotlin.codegen.optimization.fixStack.FixStackValue;
import org.jetbrains.kotlin.codegen.optimization.fixStack.LocalVariablesManager;
import org.jetbrains.kotlin.codegen.optimization.fixStack.SavedStackDescriptor;
import org.jetbrains.kotlin.codegen.optimization.fixStack.StackTransformationUtilsKt;
import org.jetbrains.kotlin.codegen.optimization.transformer.MethodTransformer;
import org.jetbrains.kotlin.codegen.pseudoInsns.PseudoInsn;
import org.jetbrains.kotlin.codegen.pseudoInsns.PseudoInsnsKt;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.InsnList;
import org.jetbrains.org.objectweb.asm.tree.JumpInsnNode;
import org.jetbrains.org.objectweb.asm.tree.LabelNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J<\u0010\u000f\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J<\u0010\u0019\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J4\u0010\u001a\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u00062\u0012\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J4\u0010\u001c\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00120\u00112\u0006\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J4\u0010\u001e\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0012\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J<\u0010\u001f\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/fixStack/FixStackMethodTransformer;", "Lorg/jetbrains/kotlin/codegen/optimization/transformer/MethodTransformer;", "()V", "analyzeAndTransformBreakContinueGotos", "", "context", "Lorg/jetbrains/kotlin/codegen/optimization/fixStack/FixStackContext;", "internalClassName", "", "methodNode", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "analyzeAndTransformSaveRestoreStack", "removeAlwaysFalseIfeqMarkers", "removeAlwaysTrueIfeqMarkers", "transform", "transformAfterInlineCallMarker", "actions", "", "Lkotlin/Function0;", "analyzer", "Lorg/jetbrains/kotlin/codegen/optimization/fixStack/FixStackAnalyzer;", "inlineMarker", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "localVariablesManager", "Lorg/jetbrains/kotlin/codegen/optimization/fixStack/LocalVariablesManager;", "transformBeforeInlineCallMarker", "transformBreakContinueGotos", "fixStackContext", "transformRestoreStackMarker", "marker", "transformSaveRestoreStackMarkers", "transformSaveStackMarker", "backend"})
public final class FixStackMethodTransformer
extends MethodTransformer {
    @Override
    public void transform(@NotNull String internalClassName, @NotNull MethodNode methodNode) {
        Intrinsics.checkNotNullParameter(internalClassName, "internalClassName");
        Intrinsics.checkNotNullParameter(methodNode, "methodNode");
        FixStackContext context = new FixStackContext(methodNode);
        if (!context.hasAnyMarkers()) {
            return;
        }
        if (!context.getConsistentInlineMarkers()) {
            InsnList insnList = methodNode.instructions;
            Intrinsics.checkNotNullExpressionValue(insnList, "methodNode.instructions");
            Sequence $this$forEach$iv = new InsnSequence(insnList);
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv = iterator2.next();
                AbstractInsnNode insnNode = (AbstractInsnNode)element$iv;
                boolean bl = false;
                if (!InlineCodegenUtilsKt.isInlineMarker(insnNode)) continue;
                methodNode.instructions.remove(insnNode);
            }
        }
        if (context.isAnalysisRequired()) {
            this.analyzeAndTransformBreakContinueGotos(context, internalClassName, methodNode);
            this.removeAlwaysFalseIfeqMarkers(context, methodNode);
            this.analyzeAndTransformSaveRestoreStack(context, internalClassName, methodNode);
        }
        this.removeAlwaysTrueIfeqMarkers(context, methodNode);
        this.removeAlwaysFalseIfeqMarkers(context, methodNode);
    }

    private final void analyzeAndTransformBreakContinueGotos(FixStackContext context, String internalClassName, MethodNode methodNode) {
        FixStackAnalyzer analyzer2 = new FixStackAnalyzer(internalClassName, methodNode, context, false, 8, null);
        analyzer2.analyze();
        methodNode.maxStack += analyzer2.getMaxExtraStackSize();
        ArrayList actions = new ArrayList();
        this.transformBreakContinueGotos(methodNode, context, actions, analyzer2);
        Iterable $this$forEach$iv = actions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Function0 it = (Function0)element$iv;
            boolean bl = false;
            it.invoke();
        }
    }

    private final void analyzeAndTransformSaveRestoreStack(FixStackContext context, String internalClassName, MethodNode methodNode) {
        FixStackAnalyzer analyzer2 = new FixStackAnalyzer(internalClassName, methodNode, context, false);
        analyzer2.analyze();
        ArrayList actions = new ArrayList();
        this.transformSaveRestoreStackMarkers(methodNode, context, actions, analyzer2);
        Iterable $this$forEach$iv = actions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Function0 it = (Function0)element$iv;
            boolean bl = false;
            it.invoke();
        }
    }

    private final void removeAlwaysFalseIfeqMarkers(FixStackContext context, MethodNode methodNode) {
        Iterable $this$forEach$iv = context.getFakeAlwaysFalseIfeqMarkers();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AbstractInsnNode marker = (AbstractInsnNode)element$iv;
            boolean bl = false;
            StackTransformationUtilsKt.removeAlwaysFalseIfeq(methodNode, marker);
        }
        context.getFakeAlwaysFalseIfeqMarkers().clear();
    }

    private final void removeAlwaysTrueIfeqMarkers(FixStackContext context, MethodNode methodNode) {
        Iterable $this$forEach$iv = context.getFakeAlwaysTrueIfeqMarkers();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AbstractInsnNode marker = (AbstractInsnNode)element$iv;
            boolean bl = false;
            StackTransformationUtilsKt.replaceAlwaysTrueIfeqWithGoto(methodNode, marker);
        }
        context.getFakeAlwaysTrueIfeqMarkers().clear();
    }

    private final void transformBreakContinueGotos(MethodNode methodNode, FixStackContext fixStackContext, List<Function0<Unit>> actions, FixStackAnalyzer analyzer2) {
        Iterable $this$forEach$iv = fixStackContext.getBreakContinueGotoNodes();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JumpInsnNode gotoNode = (JumpInsnNode)element$iv;
            boolean bl = false;
            int gotoIndex = methodNode.instructions.indexOf(gotoNode);
            int labelIndex = methodNode.instructions.indexOf(gotoNode.label);
            int actualStackSize = analyzer2.getActualStackSize(gotoNode);
            LabelNode labelNode = gotoNode.label;
            Intrinsics.checkNotNullExpressionValue(labelNode, "gotoNode.label");
            int expectedStackSize = analyzer2.getExpectedStackSize(labelNode);
            if (actualStackSize >= 0 && expectedStackSize >= 0) {
                List<FixStackValue> actualStackContent;
                boolean bl2;
                boolean bl3 = bl2 = expectedStackSize <= actualStackSize;
                if (_Assertions.ENABLED && !bl2) {
                    boolean bl4 = false;
                    String string2 = "Label at " + labelIndex + ", jump at " + gotoIndex + ": stack underflow: " + expectedStackSize + " > " + actualStackSize;
                    throw new AssertionError((Object)string2);
                }
                if (analyzer2.getActualStack(gotoNode) == null) {
                    throw new AssertionError((Object)("Jump at " + gotoIndex + " should be alive"));
                }
                actions.add(new Function0<Unit>(methodNode, gotoNode, expectedStackSize, actualStackContent){
                    final /* synthetic */ MethodNode $methodNode;
                    final /* synthetic */ JumpInsnNode $gotoNode;
                    final /* synthetic */ int $expectedStackSize;
                    final /* synthetic */ List<FixStackValue> $actualStackContent;
                    {
                        this.$methodNode = $methodNode;
                        this.$gotoNode = $gotoNode;
                        this.$expectedStackSize = $expectedStackSize;
                        this.$actualStackContent = $actualStackContent;
                        super(0);
                    }

                    public final void invoke() {
                        AbstractInsnNode abstractInsnNode = this.$gotoNode.getPrevious();
                        Intrinsics.checkNotNullExpressionValue(abstractInsnNode, "gotoNode.previous");
                        StackTransformationUtilsKt.replaceMarkerWithPops(this.$methodNode, abstractInsnNode, this.$expectedStackSize, this.$actualStackContent);
                    }
                });
                continue;
            }
            if (actualStackSize >= 0 && expectedStackSize < 0) {
                throw new AssertionError((Object)("Live jump " + gotoIndex + " to dead label " + labelIndex));
            }
            AbstractInsnNode marker = gotoNode.getPrevious();
            actions.add(new Function0<Unit>(methodNode, marker){
                final /* synthetic */ MethodNode $methodNode;
                final /* synthetic */ AbstractInsnNode $marker;
                {
                    this.$methodNode = $methodNode;
                    this.$marker = $marker;
                    super(0);
                }

                public final void invoke() {
                    this.$methodNode.instructions.remove(this.$marker);
                }
            });
        }
    }

    private final void transformSaveRestoreStackMarkers(MethodNode methodNode, FixStackContext context, List<Function0<Unit>> actions, FixStackAnalyzer analyzer2) {
        LocalVariablesManager localVariablesManager = new LocalVariablesManager(context, methodNode);
        InsnList insnList = methodNode.instructions;
        Intrinsics.checkNotNullExpressionValue(insnList, "methodNode.instructions");
        Sequence $this$forEach$iv = new InsnSequence(insnList);
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv = iterator2.next();
            AbstractInsnNode marker = (AbstractInsnNode)element$iv;
            boolean bl = false;
            PseudoInsn pseudoInsn = PseudoInsnsKt.parsePseudoInsnOrNull(marker);
            if (pseudoInsn == PseudoInsn.SAVE_STACK_BEFORE_TRY) {
                this.transformSaveStackMarker(methodNode, actions, analyzer2, marker, localVariablesManager);
                continue;
            }
            if (pseudoInsn == PseudoInsn.RESTORE_STACK_IN_TRY_CATCH) {
                this.transformRestoreStackMarker(methodNode, actions, marker, localVariablesManager);
                continue;
            }
            if (InlineCodegenUtilsKt.isBeforeInlineMarker(marker)) {
                this.transformBeforeInlineCallMarker(methodNode, actions, analyzer2, marker, localVariablesManager);
                continue;
            }
            if (!InlineCodegenUtilsKt.isAfterInlineMarker(marker)) continue;
            this.transformAfterInlineCallMarker(methodNode, actions, analyzer2, marker, localVariablesManager);
        }
    }

    private final void transformSaveStackMarker(MethodNode methodNode, List<Function0<Unit>> actions, FixStackAnalyzer analyzer2, AbstractInsnNode marker, LocalVariablesManager localVariablesManager) {
        List<FixStackValue> savedStackValues = analyzer2.getStackToSpill(marker);
        if (savedStackValues != null) {
            SavedStackDescriptor savedStackDescriptor = localVariablesManager.allocateVariablesForSaveStackMarker(marker, savedStackValues);
            actions.add(new Function0<Unit>(methodNode, marker, savedStackDescriptor){
                final /* synthetic */ MethodNode $methodNode;
                final /* synthetic */ AbstractInsnNode $marker;
                final /* synthetic */ SavedStackDescriptor $savedStackDescriptor;
                {
                    this.$methodNode = $methodNode;
                    this.$marker = $marker;
                    this.$savedStackDescriptor = $savedStackDescriptor;
                    super(0);
                }

                public final void invoke() {
                    StackTransformationUtilsKt.saveStack(this.$methodNode, this.$marker, this.$savedStackDescriptor);
                }
            });
        } else {
            localVariablesManager.allocateVariablesForSaveStackMarker(marker, CollectionsKt.emptyList());
            actions.add(new Function0<Unit>(methodNode, marker){
                final /* synthetic */ MethodNode $methodNode;
                final /* synthetic */ AbstractInsnNode $marker;
                {
                    this.$methodNode = $methodNode;
                    this.$marker = $marker;
                    super(0);
                }

                public final void invoke() {
                    this.$methodNode.instructions.remove(this.$marker);
                }
            });
        }
    }

    private final void transformRestoreStackMarker(MethodNode methodNode, List<Function0<Unit>> actions, AbstractInsnNode marker, LocalVariablesManager localVariablesManager) {
        SavedStackDescriptor savedStackDescriptor = localVariablesManager.getSavedStackDescriptor(marker);
        actions.add(new Function0<Unit>(methodNode, marker, savedStackDescriptor){
            final /* synthetic */ MethodNode $methodNode;
            final /* synthetic */ AbstractInsnNode $marker;
            final /* synthetic */ SavedStackDescriptor $savedStackDescriptor;
            {
                this.$methodNode = $methodNode;
                this.$marker = $marker;
                this.$savedStackDescriptor = $savedStackDescriptor;
                super(0);
            }

            public final void invoke() {
                StackTransformationUtilsKt.restoreStack(this.$methodNode, this.$marker, this.$savedStackDescriptor);
            }
        });
        localVariablesManager.markRestoreStackMarkerEmitted(marker);
    }

    private final void transformAfterInlineCallMarker(MethodNode methodNode, List<Function0<Unit>> actions, FixStackAnalyzer analyzer2, AbstractInsnNode inlineMarker, LocalVariablesManager localVariablesManager) {
        block5: {
            block4: {
                SavedStackDescriptor savedStackDescriptor = localVariablesManager.getBeforeInlineDescriptor(inlineMarker);
                List<FixStackValue> stackContentAfterInline = analyzer2.getActualStack(inlineMarker);
                if (stackContentAfterInline == null || !savedStackDescriptor.isNotEmpty()) break block4;
                switch (stackContentAfterInline.size()) {
                    case 1: {
                        FixStackValue returnValue = CollectionsKt.last(stackContentAfterInline);
                        int returnValueLocalVarIndex = localVariablesManager.createReturnValueVariable(returnValue);
                        actions.add(new Function0<Unit>(methodNode, inlineMarker, savedStackDescriptor, returnValue, returnValueLocalVarIndex){
                            final /* synthetic */ MethodNode $methodNode;
                            final /* synthetic */ AbstractInsnNode $inlineMarker;
                            final /* synthetic */ SavedStackDescriptor $savedStackDescriptor;
                            final /* synthetic */ FixStackValue $returnValue;
                            final /* synthetic */ int $returnValueLocalVarIndex;
                            {
                                this.$methodNode = $methodNode;
                                this.$inlineMarker = $inlineMarker;
                                this.$savedStackDescriptor = $savedStackDescriptor;
                                this.$returnValue = $returnValue;
                                this.$returnValueLocalVarIndex = $returnValueLocalVarIndex;
                                super(0);
                            }

                            public final void invoke() {
                                StackTransformationUtilsKt.restoreStackWithReturnValue(this.$methodNode, this.$inlineMarker, this.$savedStackDescriptor, this.$returnValue, this.$returnValueLocalVarIndex);
                            }
                        });
                        break block5;
                    }
                    case 0: {
                        actions.add(new Function0<Unit>(methodNode, inlineMarker, savedStackDescriptor){
                            final /* synthetic */ MethodNode $methodNode;
                            final /* synthetic */ AbstractInsnNode $inlineMarker;
                            final /* synthetic */ SavedStackDescriptor $savedStackDescriptor;
                            {
                                this.$methodNode = $methodNode;
                                this.$inlineMarker = $inlineMarker;
                                this.$savedStackDescriptor = $savedStackDescriptor;
                                super(0);
                            }

                            public final void invoke() {
                                StackTransformationUtilsKt.restoreStack(this.$methodNode, this.$inlineMarker, this.$savedStackDescriptor);
                            }
                        });
                        break block5;
                    }
                    default: {
                        throw new AssertionError((Object)"Inline method should not leave more than 1 value on stack");
                    }
                }
            }
            actions.add(new Function0<Unit>(methodNode, inlineMarker){
                final /* synthetic */ MethodNode $methodNode;
                final /* synthetic */ AbstractInsnNode $inlineMarker;
                {
                    this.$methodNode = $methodNode;
                    this.$inlineMarker = $inlineMarker;
                    super(0);
                }

                public final void invoke() {
                    this.$methodNode.instructions.remove(this.$inlineMarker);
                }
            });
        }
        localVariablesManager.markAfterInlineMarkerEmitted(inlineMarker);
    }

    private final void transformBeforeInlineCallMarker(MethodNode methodNode, List<Function0<Unit>> actions, FixStackAnalyzer analyzer2, AbstractInsnNode inlineMarker, LocalVariablesManager localVariablesManager) {
        List<FixStackValue> savedStackValues = analyzer2.getStackToSpill(inlineMarker);
        if (savedStackValues != null) {
            SavedStackDescriptor savedStackDescriptor = localVariablesManager.allocateVariablesForBeforeInlineMarker(inlineMarker, savedStackValues);
            actions.add(new Function0<Unit>(methodNode, inlineMarker, savedStackDescriptor){
                final /* synthetic */ MethodNode $methodNode;
                final /* synthetic */ AbstractInsnNode $inlineMarker;
                final /* synthetic */ SavedStackDescriptor $savedStackDescriptor;
                {
                    this.$methodNode = $methodNode;
                    this.$inlineMarker = $inlineMarker;
                    this.$savedStackDescriptor = $savedStackDescriptor;
                    super(0);
                }

                public final void invoke() {
                    StackTransformationUtilsKt.saveStack(this.$methodNode, this.$inlineMarker, this.$savedStackDescriptor);
                }
            });
        } else {
            localVariablesManager.allocateVariablesForBeforeInlineMarker(inlineMarker, CollectionsKt.emptyList());
            actions.add(new Function0<Unit>(methodNode, inlineMarker){
                final /* synthetic */ MethodNode $methodNode;
                final /* synthetic */ AbstractInsnNode $inlineMarker;
                {
                    this.$methodNode = $methodNode;
                    this.$inlineMarker = $inlineMarker;
                    super(0);
                }

                public final void invoke() {
                    this.$methodNode.instructions.remove(this.$inlineMarker);
                }
            });
        }
    }
}

