/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.inference.components;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.progress.ProgressIndicatorAndCompilationCanceledStatus;
import org.jetbrains.kotlin.resolve.calls.inference.components.ConstraintContext;
import org.jetbrains.kotlin.resolve.calls.inference.components.ConstraintIncorporatorKt;
import org.jetbrains.kotlin.resolve.calls.inference.components.ConstraintSystemUtilContext;
import org.jetbrains.kotlin.resolve.calls.inference.components.TrivialConstraintTypeInferenceOracle;
import org.jetbrains.kotlin.resolve.calls.inference.components.VariableFixationFinderKt;
import org.jetbrains.kotlin.resolve.calls.inference.model.Constraint;
import org.jetbrains.kotlin.resolve.calls.inference.model.ConstraintKind;
import org.jetbrains.kotlin.resolve.calls.inference.model.ConstraintPosition;
import org.jetbrains.kotlin.resolve.calls.inference.model.DeclaredUpperBoundConstraintPosition;
import org.jetbrains.kotlin.resolve.calls.inference.model.FixVariableConstraintPosition;
import org.jetbrains.kotlin.resolve.calls.inference.model.OnlyInputTypeConstraintPosition;
import org.jetbrains.kotlin.resolve.calls.inference.model.VariableWithConstraints;
import org.jetbrains.kotlin.types.AbstractTypeApproximator;
import org.jetbrains.kotlin.types.TypeApproximatorConfiguration;
import org.jetbrains.kotlin.types.model.CaptureStatus;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;
import org.jetbrains.kotlin.types.model.MarkerExtensionsKt;
import org.jetbrains.kotlin.types.model.ObsoleteTypeKind;
import org.jetbrains.kotlin.types.model.SimpleTypeMarker;
import org.jetbrains.kotlin.types.model.TypeArgumentListMarker;
import org.jetbrains.kotlin.types.model.TypeArgumentMarker;
import org.jetbrains.kotlin.types.model.TypeConstructorMarker;
import org.jetbrains.kotlin.types.model.TypeSubstitutorMarker;
import org.jetbrains.kotlin.types.model.TypeSystemInferenceExtensionContext;
import org.jetbrains.kotlin.types.model.TypeVariableMarker;
import org.jetbrains.kotlin.types.model.TypeVariableTypeConstructorMarker;
import org.jetbrains.kotlin.types.model.TypeVariance;
import org.jetbrains.kotlin.utils.SmartList;
import org.jetbrains.kotlin.utils.SmartSet;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u00011B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u001e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bJ<\u0010\u001c\u001a\u00020\u0015*\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\u00192\u0006\u0010 \u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\u00102\u0006\u0010\"\u001a\u00020\u0013H\u0002J>\u0010#\u001a\u00020\u0015*\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020\u00192\u0006\u0010 \u001a\u00020\u001b2\b\b\u0002\u0010$\u001a\u00020\u0013H\u0002J\u001c\u0010%\u001a\u00020\u0013*\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u001c\u0010&\u001a\u00020\u0013*\u00020\u00172\u0006\u0010!\u001a\u00020\u00102\u0006\u0010 \u001a\u00020\u001bH\u0002J\u001c\u0010'\u001a\u00020\u0015*\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J,\u0010(\u001a\u00020\u0015*\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\u00192\u0006\u0010 \u001a\u00020\u001bH\u0002J\u001a\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00190**\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u0010H\u0002J\u001c\u0010+\u001a\u00020\u0015*\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J$\u0010,\u001a\u00020\u0013*\u00020\u00172\u0006\u0010!\u001a\u00020\u00102\u0006\u0010 \u001a\u00020\u00102\u0006\u0010-\u001a\u00020.H\u0002J$\u0010/\u001a\u00020\u0010*\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u00100\u001a\u00020\u0010H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u00062"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/inference/components/ConstraintIncorporator;", "", "typeApproximator", "Lorg/jetbrains/kotlin/types/AbstractTypeApproximator;", "trivialConstraintTypeInferenceOracle", "Lorg/jetbrains/kotlin/resolve/calls/inference/components/TrivialConstraintTypeInferenceOracle;", "utilContext", "Lorg/jetbrains/kotlin/resolve/calls/inference/components/ConstraintSystemUtilContext;", "(Lorg/jetbrains/kotlin/types/AbstractTypeApproximator;Lorg/jetbrains/kotlin/resolve/calls/inference/components/TrivialConstraintTypeInferenceOracle;Lorg/jetbrains/kotlin/resolve/calls/inference/components/ConstraintSystemUtilContext;)V", "getTrivialConstraintTypeInferenceOracle", "()Lorg/jetbrains/kotlin/resolve/calls/inference/components/TrivialConstraintTypeInferenceOracle;", "getTypeApproximator", "()Lorg/jetbrains/kotlin/types/AbstractTypeApproximator;", "getUtilContext", "()Lorg/jetbrains/kotlin/resolve/calls/inference/components/ConstraintSystemUtilContext;", "approximateCapturedTypes", "Lorg/jetbrains/kotlin/types/model/KotlinTypeMarker;", "type", "toSuper", "", "incorporate", "", "c", "Lorg/jetbrains/kotlin/resolve/calls/inference/components/ConstraintIncorporator$Context;", "typeVariable", "Lorg/jetbrains/kotlin/types/model/TypeVariableMarker;", "constraint", "Lorg/jetbrains/kotlin/resolve/calls/inference/model/Constraint;", "addNewConstraint", "targetVariable", "baseConstraint", "otherVariable", "otherConstraint", "newConstraint", "isSubtype", "approximateIfNeededAndAddNewConstraint", "needApproximation", "areThereRecursiveConstraints", "containsConstrainingTypeWithoutProjection", "directWithVariable", "generateNewConstraint", "getNestedTypeVariables", "", "insideOtherConstraint", "isPotentialUsefulNullabilityConstraint", "kind", "Lorg/jetbrains/kotlin/resolve/calls/inference/model/ConstraintKind;", "substitute", "value", "Context", "resolution.common"})
public final class ConstraintIncorporator {
    @NotNull
    private final AbstractTypeApproximator typeApproximator;
    @NotNull
    private final TrivialConstraintTypeInferenceOracle trivialConstraintTypeInferenceOracle;
    @NotNull
    private final ConstraintSystemUtilContext utilContext;

    public ConstraintIncorporator(@NotNull AbstractTypeApproximator typeApproximator, @NotNull TrivialConstraintTypeInferenceOracle trivialConstraintTypeInferenceOracle, @NotNull ConstraintSystemUtilContext utilContext) {
        Intrinsics.checkNotNullParameter(typeApproximator, "typeApproximator");
        Intrinsics.checkNotNullParameter(trivialConstraintTypeInferenceOracle, "trivialConstraintTypeInferenceOracle");
        Intrinsics.checkNotNullParameter(utilContext, "utilContext");
        this.typeApproximator = typeApproximator;
        this.trivialConstraintTypeInferenceOracle = trivialConstraintTypeInferenceOracle;
        this.utilContext = utilContext;
    }

    @NotNull
    public final AbstractTypeApproximator getTypeApproximator() {
        return this.typeApproximator;
    }

    @NotNull
    public final TrivialConstraintTypeInferenceOracle getTrivialConstraintTypeInferenceOracle() {
        return this.trivialConstraintTypeInferenceOracle;
    }

    @NotNull
    public final ConstraintSystemUtilContext getUtilContext() {
        return this.utilContext;
    }

    public final void incorporate(@NotNull Context c, @NotNull TypeVariableMarker typeVariable2, @NotNull Constraint constraint2) {
        Intrinsics.checkNotNullParameter(c, "c");
        Intrinsics.checkNotNullParameter(typeVariable2, "typeVariable");
        Intrinsics.checkNotNullParameter(constraint2, "constraint");
        ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
        if (this.areThereRecursiveConstraints(c, typeVariable2, constraint2)) {
            return;
        }
        this.directWithVariable(c, typeVariable2, constraint2);
        this.insideOtherConstraint(c, typeVariable2, constraint2);
    }

    private final boolean areThereRecursiveConstraints(Context $this$areThereRecursiveConstraints, TypeVariableMarker typeVariable2, Constraint constraint2) {
        return $this$areThereRecursiveConstraints.contains(constraint2.getType(), (Function1<? super KotlinTypeMarker, Boolean>)new Function1<KotlinTypeMarker, Boolean>($this$areThereRecursiveConstraints, typeVariable2){
            final /* synthetic */ Context $this_areThereRecursiveConstraints;
            final /* synthetic */ TypeVariableMarker $typeVariable;
            {
                this.$this_areThereRecursiveConstraints = $receiver;
                this.$typeVariable = $typeVariable;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull KotlinTypeMarker it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return Intrinsics.areEqual(this.$this_areThereRecursiveConstraints.unwrapStubTypeVariableConstructor(this.$this_areThereRecursiveConstraints.typeConstructor(it)), this.$this_areThereRecursiveConstraints.freshTypeConstructor(this.$typeVariable));
            }
        });
    }

    private final void directWithVariable(Context $this$directWithVariable, TypeVariableMarker typeVariable2, Constraint constraint2) {
        Constraint it;
        Iterable $this$forEach$iv;
        ConstraintSystemUtilContext $this$directWithVariable_u24lambda_u2d0 = this.utilContext;
        boolean bl = false;
        boolean shouldBeTypeVariableFlexible = $this$directWithVariable_u24lambda_u2d0.shouldBeFlexible(typeVariable2);
        if (constraint2.getKind() != ConstraintKind.LOWER) {
            $this$forEach$iv = $this$directWithVariable.getConstraintsForVariable(typeVariable2);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (Constraint)element$iv;
                boolean bl2 = false;
                if (it.getKind() == ConstraintKind.UPPER) continue;
                Context.DefaultImpls.addNewIncorporatedConstraint$default($this$directWithVariable, it.getType(), constraint2.getType(), shouldBeTypeVariableFlexible, it.isNullabilityConstraint(), false, 16, null);
            }
        }
        if (constraint2.getKind() != ConstraintKind.UPPER) {
            $this$forEach$iv = $this$directWithVariable.getConstraintsForVariable(typeVariable2);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (Constraint)element$iv;
                boolean bl3 = false;
                if (it.getKind() == ConstraintKind.LOWER) continue;
                boolean isFromDeclaredUpperBound = it.getPosition().getFrom() instanceof DeclaredUpperBoundConstraintPosition && !$this$directWithVariable.isTypeVariable($this$directWithVariable.typeConstructor(it.getType()));
                Context.DefaultImpls.addNewIncorporatedConstraint$default($this$directWithVariable, constraint2.getType(), it.getType(), shouldBeTypeVariableFlexible, false, isFromDeclaredUpperBound, 8, null);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void insideOtherConstraint(Context $this$insideOtherConstraint, TypeVariableMarker typeVariable2, Constraint constraint2) {
        TypeConstructorMarker freshTypeConstructor = $this$insideOtherConstraint.freshTypeConstructor(typeVariable2);
        for (VariableWithConstraints typeVariableWithConstraint : $this$insideOtherConstraint.getAllTypeVariablesWithConstraints()) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = typeVariableWithConstraint.getConstraints();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Constraint it = (Constraint)element$iv$iv;
                boolean bl = false;
                if (!VariableFixationFinderKt.containsTypeVariable($this$insideOtherConstraint, it.getType(), freshTypeConstructor)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List constraintsWhichConstraintMyVariable = (List)destination$iv$iv;
            Iterable $this$forEach$iv = constraintsWhichConstraintMyVariable;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Constraint it = (Constraint)element$iv;
                boolean bl = false;
                this.generateNewConstraint($this$insideOtherConstraint, typeVariableWithConstraint.getTypeVariable(), it, typeVariable2, constraint2);
            }
        }
    }

    private final void approximateIfNeededAndAddNewConstraint(Context $this$approximateIfNeededAndAddNewConstraint, Constraint baseConstraint, KotlinTypeMarker type2, TypeVariableMarker targetVariable, TypeVariableMarker otherVariable, Constraint otherConstraint, boolean needApproximation) {
        KotlinTypeMarker typeWithSubstitution = this.substitute(baseConstraint.getType(), $this$approximateIfNeededAndAddNewConstraint, otherVariable, type2);
        Function1 prepareType2 = new Function1<Boolean, KotlinTypeMarker>(needApproximation, this, typeWithSubstitution){
            final /* synthetic */ boolean $needApproximation;
            final /* synthetic */ ConstraintIncorporator this$0;
            final /* synthetic */ KotlinTypeMarker $typeWithSubstitution;
            {
                this.$needApproximation = $needApproximation;
                this.this$0 = $receiver;
                this.$typeWithSubstitution = $typeWithSubstitution;
                super(1);
            }

            @NotNull
            public final KotlinTypeMarker invoke(boolean toSuper) {
                return this.$needApproximation ? ConstraintIncorporator.access$approximateCapturedTypes(this.this$0, this.$typeWithSubstitution, toSuper) : this.$typeWithSubstitution;
            }
        };
        if (baseConstraint.getKind() != ConstraintKind.LOWER) {
            this.addNewConstraint($this$approximateIfNeededAndAddNewConstraint, targetVariable, baseConstraint, otherVariable, otherConstraint, (KotlinTypeMarker)prepareType2.invoke(true), false);
        }
        if (baseConstraint.getKind() != ConstraintKind.UPPER) {
            this.addNewConstraint($this$approximateIfNeededAndAddNewConstraint, targetVariable, baseConstraint, otherVariable, otherConstraint, (KotlinTypeMarker)prepareType2.invoke(false), true);
        }
    }

    private final void generateNewConstraint(Context $this$generateNewConstraint, TypeVariableMarker targetVariable, Constraint baseConstraint, TypeVariableMarker otherVariable, Constraint otherConstraint) {
        Pair<KotlinTypeMarker, Boolean> pair;
        boolean isBaseGenericType = $this$generateNewConstraint.argumentsCount(baseConstraint.getType()) != 0;
        boolean isBaseOrOtherCapturedType = $this$generateNewConstraint.isCapturedType(baseConstraint.getType()) || $this$generateNewConstraint.isCapturedType(otherConstraint.getType());
        switch (WhenMappings.$EnumSwitchMapping$0[otherConstraint.getKind().ordinal()]) {
            case 1: {
                pair = TuplesKt.to(otherConstraint.getType(), false);
                break;
            }
            case 2: {
                if (baseConstraint.getKind() == ConstraintKind.LOWER && !isBaseGenericType && !isBaseOrOtherCapturedType) {
                    pair = TuplesKt.to($this$generateNewConstraint.nothingType(), false);
                    break;
                }
                if (baseConstraint.getKind() == ConstraintKind.UPPER && !isBaseGenericType && !isBaseOrOtherCapturedType) {
                    pair = TuplesKt.to(otherConstraint.getType(), false);
                    break;
                }
                pair = TuplesKt.to($this$generateNewConstraint.createCapturedType($this$generateNewConstraint.createTypeArgument(otherConstraint.getType(), TypeVariance.OUT), CollectionsKt.listOf(otherConstraint.getType()), null, CaptureStatus.FOR_INCORPORATION), true);
                break;
            }
            case 3: {
                if (baseConstraint.getKind() == ConstraintKind.UPPER && !isBaseGenericType && !isBaseOrOtherCapturedType) {
                    pair = TuplesKt.to($this$generateNewConstraint.nullableAnyType(), false);
                    break;
                }
                if (baseConstraint.getKind() == ConstraintKind.LOWER && !isBaseGenericType && !isBaseOrOtherCapturedType) {
                    pair = TuplesKt.to(otherConstraint.getType(), false);
                    break;
                }
                pair = TuplesKt.to($this$generateNewConstraint.createCapturedType($this$generateNewConstraint.createTypeArgument(otherConstraint.getType(), TypeVariance.IN), CollectionsKt.emptyList(), otherConstraint.getType(), CaptureStatus.FOR_INCORPORATION), true);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Pair<KotlinTypeMarker, Boolean> pair2 = pair;
        KotlinTypeMarker type2 = pair2.component1();
        boolean needApproximation = pair2.component2();
        this.approximateIfNeededAndAddNewConstraint($this$generateNewConstraint, baseConstraint, type2, targetVariable, otherVariable, otherConstraint, needApproximation);
    }

    private final void addNewConstraint(Context $this$addNewConstraint, TypeVariableMarker targetVariable, Constraint baseConstraint, TypeVariableMarker otherVariable, Constraint otherConstraint, KotlinTypeMarker newConstraint, boolean isSubtype) {
        SmartSet<TypeVariableMarker> smartSet;
        boolean isFromVariableFixation;
        if (this.getNestedTypeVariables($this$addNewConstraint, newConstraint).contains(targetVariable)) {
            return;
        }
        boolean isUsefulForNullabilityConstraint = this.isPotentialUsefulNullabilityConstraint($this$addNewConstraint, newConstraint, otherConstraint.getType(), otherConstraint.getKind());
        boolean bl = isFromVariableFixation = baseConstraint.getPosition().getFrom() instanceof FixVariableConstraintPosition || otherConstraint.getPosition().getFrom() instanceof FixVariableConstraintPosition;
        if (!(otherConstraint.getKind().isEqual() || isUsefulForNullabilityConstraint || isFromVariableFixation || this.containsConstrainingTypeWithoutProjection($this$addNewConstraint, newConstraint, otherConstraint))) {
            return;
        }
        if (this.trivialConstraintTypeInferenceOracle.isGeneratedConstraintTrivial(baseConstraint, otherConstraint, newConstraint, isSubtype)) {
            return;
        }
        SmartSet<TypeVariableMarker> it = smartSet = SmartSet.Companion.create((Collection)baseConstraint.getDerivedFrom());
        boolean bl2 = false;
        it.addAll(otherConstraint.getDerivedFrom());
        SmartSet<TypeVariableMarker> derivedFrom = smartSet;
        if (derivedFrom.contains(otherVariable)) {
            return;
        }
        derivedFrom.add(otherVariable);
        ConstraintKind kind = isSubtype ? ConstraintKind.LOWER : ConstraintKind.UPPER;
        ConstraintPosition constraintPosition = baseConstraint.getPosition().getFrom();
        OnlyInputTypeConstraintPosition onlyInputTypeConstraintPosition = constraintPosition instanceof OnlyInputTypeConstraintPosition ? (OnlyInputTypeConstraintPosition)((Object)constraintPosition) : null;
        if (onlyInputTypeConstraintPosition == null) {
            onlyInputTypeConstraintPosition = baseConstraint.getInputTypePositionBeforeIncorporation();
        }
        OnlyInputTypeConstraintPosition inputTypePosition = onlyInputTypeConstraintPosition;
        boolean isNewConstraintUsefulForNullability = isUsefulForNullabilityConstraint && $this$addNewConstraint.isNullableNothing(newConstraint);
        boolean isOtherConstraintUsefulForNullability = otherConstraint.isNullabilityConstraint() && $this$addNewConstraint.isNullableNothing(otherConstraint.getType());
        boolean isNullabilityConstraint = isNewConstraintUsefulForNullability || isOtherConstraintUsefulForNullability;
        ConstraintContext constraintContext = new ConstraintContext(kind, (Set<? extends TypeVariableMarker>)derivedFrom, inputTypePosition, isNullabilityConstraint);
        $this$addNewConstraint.addNewIncorporatedConstraint(targetVariable, newConstraint, constraintContext);
    }

    private final boolean containsConstrainingTypeWithoutProjection(Context $this$containsConstrainingTypeWithoutProjection, KotlinTypeMarker newConstraint, Constraint otherConstraint) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = ConstraintIncorporatorKt.access$getNestedArguments($this$containsConstrainingTypeWithoutProjection, newConstraint);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    TypeArgumentMarker it = (TypeArgumentMarker)element$iv;
                    boolean bl2 = false;
                    if (!(Intrinsics.areEqual($this$containsConstrainingTypeWithoutProjection.typeConstructor($this$containsConstrainingTypeWithoutProjection.getType(it)), $this$containsConstrainingTypeWithoutProjection.typeConstructor(otherConstraint.getType())) && $this$containsConstrainingTypeWithoutProjection.getVariance(it) == TypeVariance.INV)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean isPotentialUsefulNullabilityConstraint(Context $this$isPotentialUsefulNullabilityConstraint, KotlinTypeMarker newConstraint, KotlinTypeMarker otherConstraint, ConstraintKind kind) {
        if (this.trivialConstraintTypeInferenceOracle.isSuitableResultedType(newConstraint)) {
            return false;
        }
        boolean otherConstraintCanAddNullabilityToNewOne = !$this$isPotentialUsefulNullabilityConstraint.isNullableType(newConstraint) && $this$isPotentialUsefulNullabilityConstraint.isNullableType(otherConstraint) && kind == ConstraintKind.LOWER;
        boolean newConstraintCanAddNullabilityToOtherOne = $this$isPotentialUsefulNullabilityConstraint.isNullableType(newConstraint) && !$this$isPotentialUsefulNullabilityConstraint.isNullableType(otherConstraint) && kind == ConstraintKind.UPPER;
        return otherConstraintCanAddNullabilityToNewOne || newConstraintCanAddNullabilityToOtherOne;
    }

    /*
     * WARNING - void declaration
     */
    private final List<TypeVariableMarker> getNestedTypeVariables(Context $this$getNestedTypeVariables, KotlinTypeMarker type2) {
        void $this$mapNotNullTo$iv;
        Iterable iterable = ConstraintIncorporatorKt.access$getNestedArguments($this$getNestedTypeVariables, type2);
        Collection destination$iv = new SmartList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv.iterator();
        while (iterator2.hasNext()) {
            TypeVariableMarker it$iv;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator2.next();
            boolean bl = false;
            TypeArgumentMarker it = (TypeArgumentMarker)element$iv;
            boolean bl2 = false;
            if ($this$getNestedTypeVariables.getTypeVariable($this$getNestedTypeVariables.unwrapStubTypeVariableConstructor($this$getNestedTypeVariables.typeConstructor($this$getNestedTypeVariables.getType(it)))) == null) continue;
            boolean bl3 = false;
            destination$iv.add(it$iv);
        }
        return (List)destination$iv;
    }

    private final KotlinTypeMarker substitute(KotlinTypeMarker $this$substitute, Context c, TypeVariableMarker typeVariable2, KotlinTypeMarker value2) {
        TypeSubstitutorMarker substitutor2 = c.typeSubstitutorByTypeConstructor(MapsKt.mapOf(TuplesKt.to(MarkerExtensionsKt.freshTypeConstructor(typeVariable2, c), value2)));
        return MarkerExtensionsKt.safeSubstitute(substitutor2, c, $this$substitute);
    }

    private final KotlinTypeMarker approximateCapturedTypes(KotlinTypeMarker type2, boolean toSuper) {
        KotlinTypeMarker kotlinTypeMarker;
        if (toSuper) {
            kotlinTypeMarker = this.typeApproximator.approximateToSuperType(type2, TypeApproximatorConfiguration.IncorporationConfiguration.INSTANCE);
            if (kotlinTypeMarker == null) {
                kotlinTypeMarker = type2;
            }
        } else {
            kotlinTypeMarker = this.typeApproximator.approximateToSubType(type2, TypeApproximatorConfiguration.IncorporationConfiguration.INSTANCE);
            if (kotlinTypeMarker == null) {
                kotlinTypeMarker = type2;
            }
        }
        return kotlinTypeMarker;
    }

    public static final /* synthetic */ KotlinTypeMarker access$approximateCapturedTypes(ConstraintIncorporator $this, KotlinTypeMarker type2, boolean toSuper) {
        return $this.approximateCapturedTypes(type2, toSuper);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J4\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\r2\b\b\u0002\u0010\u000f\u001a\u00020\rH&J \u0010\u0007\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0014H&J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u00032\u0006\u0010\u0010\u001a\u00020\u0011H&J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0018\u001a\u00020\u0019H&R\u0018\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/inference/components/ConstraintIncorporator$Context;", "Lorg/jetbrains/kotlin/types/model/TypeSystemInferenceExtensionContext;", "allTypeVariablesWithConstraints", "", "Lorg/jetbrains/kotlin/resolve/calls/inference/model/VariableWithConstraints;", "getAllTypeVariablesWithConstraints", "()Ljava/util/Collection;", "addNewIncorporatedConstraint", "", "lowerType", "Lorg/jetbrains/kotlin/types/model/KotlinTypeMarker;", "upperType", "shouldTryUseDifferentFlexibilityForUpperType", "", "isFromNullabilityConstraint", "isFromDeclaredUpperBound", "typeVariable", "Lorg/jetbrains/kotlin/types/model/TypeVariableMarker;", "type", "constraintContext", "Lorg/jetbrains/kotlin/resolve/calls/inference/components/ConstraintContext;", "getConstraintsForVariable", "Lorg/jetbrains/kotlin/resolve/calls/inference/model/Constraint;", "getTypeVariable", "typeConstructor", "Lorg/jetbrains/kotlin/types/model/TypeConstructorMarker;", "resolution.common"})
    public static interface Context
    extends TypeSystemInferenceExtensionContext {
        @NotNull
        public Collection<VariableWithConstraints> getAllTypeVariablesWithConstraints();

        @Nullable
        public TypeVariableMarker getTypeVariable(@NotNull TypeConstructorMarker var1);

        @NotNull
        public Collection<Constraint> getConstraintsForVariable(@NotNull TypeVariableMarker var1);

        public void addNewIncorporatedConstraint(@NotNull KotlinTypeMarker var1, @NotNull KotlinTypeMarker var2, boolean var3, boolean var4, boolean var5);

        public void addNewIncorporatedConstraint(@NotNull TypeVariableMarker var1, @NotNull KotlinTypeMarker var2, @NotNull ConstraintContext var3);

        @Metadata(mv={1, 7, 1}, k=3, xi=48)
        public static final class DefaultImpls {
            public static /* synthetic */ void addNewIncorporatedConstraint$default(Context context, KotlinTypeMarker kotlinTypeMarker, KotlinTypeMarker kotlinTypeMarker2, boolean bl, boolean bl2, boolean bl3, int n, Object object) {
                if (object != null) {
                    throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: addNewIncorporatedConstraint");
                }
                if ((n & 8) != 0) {
                    bl2 = false;
                }
                if ((n & 0x10) != 0) {
                    bl3 = false;
                }
                context.addNewIncorporatedConstraint(kotlinTypeMarker, kotlinTypeMarker2, bl, bl2, bl3);
            }

            @Nullable
            public static SimpleTypeMarker createCapturedStarProjectionForSelfType(@NotNull Context $this, @NotNull TypeVariableTypeConstructorMarker typeVariable2, @NotNull List<? extends KotlinTypeMarker> typesForRecursiveTypeParameters) {
                Intrinsics.checkNotNullParameter(typeVariable2, "typeVariable");
                Intrinsics.checkNotNullParameter(typesForRecursiveTypeParameters, "typesForRecursiveTypeParameters");
                return TypeSystemInferenceExtensionContext.DefaultImpls.createCapturedStarProjectionForSelfType($this, typeVariable2, typesForRecursiveTypeParameters);
            }

            public static boolean identicalArguments(@NotNull Context $this, @NotNull SimpleTypeMarker a, @NotNull SimpleTypeMarker b) {
                Intrinsics.checkNotNullParameter(a, "a");
                Intrinsics.checkNotNullParameter(b, "b");
                return TypeSystemInferenceExtensionContext.DefaultImpls.identicalArguments($this, a, b);
            }

            public static boolean anySuperTypeConstructor(@NotNull Context $this, @NotNull KotlinTypeMarker $receiver, @NotNull Function1<? super TypeConstructorMarker, Boolean> predicate) {
                Intrinsics.checkNotNullParameter($receiver, "$receiver");
                Intrinsics.checkNotNullParameter(predicate, "predicate");
                return TypeSystemInferenceExtensionContext.DefaultImpls.anySuperTypeConstructor($this, $receiver, predicate);
            }

            @NotNull
            public static Set<TypeVariableTypeConstructorMarker> extractTypeVariables(@NotNull Context $this, @NotNull KotlinTypeMarker $receiver) {
                Intrinsics.checkNotNullParameter($receiver, "$receiver");
                return TypeSystemInferenceExtensionContext.DefaultImpls.extractTypeVariables($this, $receiver);
            }

            @Nullable
            public static List<SimpleTypeMarker> fastCorrespondingSupertypes(@NotNull Context $this, @NotNull SimpleTypeMarker $receiver, @NotNull TypeConstructorMarker constructor2) {
                Intrinsics.checkNotNullParameter($receiver, "$receiver");
                Intrinsics.checkNotNullParameter(constructor2, "constructor");
                return TypeSystemInferenceExtensionContext.DefaultImpls.fastCorrespondingSupertypes($this, $receiver, constructor2);
            }

            @NotNull
            public static TypeArgumentMarker get(@NotNull Context $this, @NotNull TypeArgumentListMarker $receiver, int index2) {
                Intrinsics.checkNotNullParameter($receiver, "$receiver");
                return TypeSystemInferenceExtensionContext.DefaultImpls.get($this, $receiver, index2);
            }

            @Nullable
            public static TypeArgumentMarker getArgumentOrNull(@NotNull Context $this, @NotNull SimpleTypeMarker $receiver, int index2) {
                Intrinsics.checkNotNullParameter($receiver, "$receiver");
                return TypeSystemInferenceExtensionContext.DefaultImpls.getArgumentOrNull($this, $receiver, index2);
            }

            public static boolean hasFlexibleNullability(@NotNull Context $this, @NotNull KotlinTypeMarker $receiver) {
                Intrinsics.checkNotNullParameter($receiver, "$receiver");
                return TypeSystemInferenceExtensionContext.DefaultImpls.hasFlexibleNullability($this, $receiver);
            }

            public static boolean isCapturedDynamic(@NotNull Context $this, @NotNull KotlinTypeMarker $receiver) {
                Intrinsics.checkNotNullParameter($receiver, "$receiver");
                return TypeSystemInferenceExtensionContext.DefaultImpls.isCapturedDynamic($this, $receiver);
            }

            public static boolean isCapturedType(@NotNull Context $this, @NotNull KotlinTypeMarker $receiver) {
                Intrinsics.checkNotNullParameter($receiver, "$receiver");
                return TypeSystemInferenceExtensionContext.DefaultImpls.isCapturedType($this, $receiver);
            }

            public static boolean isClassType(@NotNull Context $this, @NotNull SimpleTypeMarker $receiver) {
                Intrinsics.checkNotNullParameter($receiver, "$receiver");
                return TypeSystemInferenceExtensionContext.DefaultImpls.isClassType($this, $receiver);
            }

            public static boolean isDefinitelyNotNullType(@NotNull Context $this, @NotNull KotlinTypeMarker $receiver) {
                Intrinsics.checkNotNullParameter($receiver, "$receiver");
                return TypeSystemInferenceExtensionContext.DefaultImpls.isDefinitelyNotNullType($this, $receiver);
            }

            public static boolean isDynamic(@NotNull Context $this, @NotNull KotlinTypeMarker $receiver) {
                Intrinsics.checkNotNullParameter($receiver, "$receiver");
                return TypeSystemInferenceExtensionContext.DefaultImpls.isDynamic($this, $receiver);
            }

            public static boolean isFlexible(@NotNull Context $this, @NotNull KotlinTypeMarker $receiver) {
                Intrinsics.checkNotNullParameter($receiver, "$receiver");
                return TypeSystemInferenceExtensionContext.DefaultImpls.isFlexible($this, $receiver);
            }

            public static boolean isFlexibleNothing(@NotNull Context $this, @NotNull KotlinTypeMarker $receiver) {
                Intrinsics.checkNotNullParameter($receiver, "$receiver");
                return TypeSystemInferenceExtensionContext.DefaultImpls.isFlexibleNothing($this, $receiver);
            }

            public static boolean isIntegerLiteralType(@NotNull Context $this, @NotNull SimpleTypeMarker $receiver) {
                Intrinsics.checkNotNullParameter($receiver, "$receiver");
                return TypeSystemInferenceExtensionContext.DefaultImpls.isIntegerLiteralType($this, $receiver);
            }

            public static boolean isMarkedNullable(@NotNull Context $this, @NotNull KotlinTypeMarker $receiver) {
                Intrinsics.checkNotNullParameter($receiver, "$receiver");
                return TypeSystemInferenceExtensionContext.DefaultImpls.isMarkedNullable($this, $receiver);
            }

            @ObsoleteTypeKind
            public static boolean isNotNullTypeParameter(@NotNull Context $this, @NotNull KotlinTypeMarker $receiver) {
                Intrinsics.checkNotNullParameter($receiver, "$receiver");
                return TypeSystemInferenceExtensionContext.DefaultImpls.isNotNullTypeParameter($this, $receiver);
            }

            public static boolean isNothing(@NotNull Context $this, @NotNull KotlinTypeMarker $receiver) {
                Intrinsics.checkNotNullParameter($receiver, "$receiver");
                return TypeSystemInferenceExtensionContext.DefaultImpls.isNothing($this, $receiver);
            }

            public static boolean isNullableAny(@NotNull Context $this, @NotNull KotlinTypeMarker $receiver) {
                Intrinsics.checkNotNullParameter($receiver, "$receiver");
                return TypeSystemInferenceExtensionContext.DefaultImpls.isNullableAny($this, $receiver);
            }

            public static boolean isNullableNothing(@NotNull Context $this, @NotNull KotlinTypeMarker $receiver) {
                Intrinsics.checkNotNullParameter($receiver, "$receiver");
                return TypeSystemInferenceExtensionContext.DefaultImpls.isNullableNothing($this, $receiver);
            }

            public static boolean isSimpleType(@NotNull Context $this, @NotNull KotlinTypeMarker $receiver) {
                Intrinsics.checkNotNullParameter($receiver, "$receiver");
                return TypeSystemInferenceExtensionContext.DefaultImpls.isSimpleType($this, $receiver);
            }

            @NotNull
            public static Iterator<TypeArgumentMarker> iterator(@NotNull Context $this, @NotNull TypeArgumentListMarker $receiver) {
                Intrinsics.checkNotNullParameter($receiver, "$receiver");
                return TypeSystemInferenceExtensionContext.DefaultImpls.iterator($this, $receiver);
            }

            @NotNull
            public static SimpleTypeMarker lowerBoundIfFlexible(@NotNull Context $this, @NotNull KotlinTypeMarker $receiver) {
                Intrinsics.checkNotNullParameter($receiver, "$receiver");
                return TypeSystemInferenceExtensionContext.DefaultImpls.lowerBoundIfFlexible($this, $receiver);
            }

            @NotNull
            public static KotlinTypeMarker replaceArguments(@NotNull Context $this, @NotNull KotlinTypeMarker $receiver, @NotNull Function1<? super TypeArgumentMarker, ? extends TypeArgumentMarker> replacement) {
                Intrinsics.checkNotNullParameter($receiver, "$receiver");
                Intrinsics.checkNotNullParameter(replacement, "replacement");
                return TypeSystemInferenceExtensionContext.DefaultImpls.replaceArguments($this, $receiver, replacement);
            }

            @NotNull
            public static KotlinTypeMarker replaceArgumentsDeeply(@NotNull Context $this, @NotNull KotlinTypeMarker $receiver, @NotNull Function1<? super TypeArgumentMarker, ? extends TypeArgumentMarker> replacement) {
                Intrinsics.checkNotNullParameter($receiver, "$receiver");
                Intrinsics.checkNotNullParameter(replacement, "replacement");
                return TypeSystemInferenceExtensionContext.DefaultImpls.replaceArgumentsDeeply((TypeSystemInferenceExtensionContext)$this, $receiver, replacement);
            }

            @NotNull
            public static SimpleTypeMarker replaceArgumentsDeeply(@NotNull Context $this, @NotNull SimpleTypeMarker $receiver, @NotNull Function1<? super TypeArgumentMarker, ? extends TypeArgumentMarker> replacement) {
                Intrinsics.checkNotNullParameter($receiver, "$receiver");
                Intrinsics.checkNotNullParameter(replacement, "replacement");
                return TypeSystemInferenceExtensionContext.DefaultImpls.replaceArgumentsDeeply((TypeSystemInferenceExtensionContext)$this, $receiver, replacement);
            }

            public static int size(@NotNull Context $this, @NotNull TypeArgumentListMarker $receiver) {
                Intrinsics.checkNotNullParameter($receiver, "$receiver");
                return TypeSystemInferenceExtensionContext.DefaultImpls.size($this, $receiver);
            }

            @NotNull
            public static TypeConstructorMarker typeConstructor(@NotNull Context $this, @NotNull KotlinTypeMarker $receiver) {
                Intrinsics.checkNotNullParameter($receiver, "$receiver");
                return TypeSystemInferenceExtensionContext.DefaultImpls.typeConstructor($this, $receiver);
            }

            public static int typeDepth(@NotNull Context $this, @NotNull KotlinTypeMarker $receiver) {
                Intrinsics.checkNotNullParameter($receiver, "$receiver");
                return TypeSystemInferenceExtensionContext.DefaultImpls.typeDepth($this, $receiver);
            }

            @NotNull
            public static SimpleTypeMarker upperBoundIfFlexible(@NotNull Context $this, @NotNull KotlinTypeMarker $receiver) {
                Intrinsics.checkNotNullParameter($receiver, "$receiver");
                return TypeSystemInferenceExtensionContext.DefaultImpls.upperBoundIfFlexible($this, $receiver);
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ConstraintKind.values().length];
            nArray[ConstraintKind.EQUALITY.ordinal()] = 1;
            nArray[ConstraintKind.UPPER.ordinal()] = 2;
            nArray[ConstraintKind.LOWER.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

