/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.HashFunctions;
import gnu.trove.SerializationProcedure;
import gnu.trove.TByteHash;
import gnu.trove.TByteHashingStrategy;
import gnu.trove.TByteIntIterator;
import gnu.trove.TByteIntProcedure;
import gnu.trove.TByteProcedure;
import gnu.trove.TIntFunction;
import gnu.trove.TIntProcedure;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class TByteIntHashMap
extends TByteHash {
    protected transient int[] _values;

    public TByteIntHashMap() {
    }

    public TByteIntHashMap(int initialCapacity) {
        super(initialCapacity);
    }

    public TByteIntHashMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public TByteIntHashMap(TByteHashingStrategy strategy) {
        super(strategy);
    }

    public TByteIntHashMap(int initialCapacity, TByteHashingStrategy strategy) {
        super(initialCapacity, strategy);
    }

    public TByteIntHashMap(int initialCapacity, float loadFactor, TByteHashingStrategy strategy) {
        super(initialCapacity, loadFactor, strategy);
    }

    public Object clone() {
        TByteIntHashMap m = (TByteIntHashMap)super.clone();
        m._values = this._values == null ? null : (int[])this._values.clone();
        return m;
    }

    public TByteIntIterator iterator() {
        return new TByteIntIterator(this);
    }

    protected int setUp(int initialCapacity) {
        int capacity = super.setUp(initialCapacity);
        this._values = initialCapacity == -1 ? null : new int[capacity];
        return capacity;
    }

    public int put(byte key, int value2) {
        int previous = 0;
        int index2 = this.insertionIndex(key);
        boolean isNewMapping = true;
        if (index2 < 0) {
            index2 = -index2 - 1;
            previous = this._values[index2];
            isNewMapping = false;
        }
        byte previousState = this._states[index2];
        this._set[index2] = key;
        this._states[index2] = 1;
        this._values[index2] = value2;
        if (isNewMapping) {
            this.postInsertHook(previousState == 0);
        }
        return previous;
    }

    protected void rehash(int newCapacity) {
        int oldCapacity = this.capacity();
        byte[] oldKeys = this._set;
        int[] oldVals = this._values;
        byte[] oldStates = this._states;
        this._set = new byte[newCapacity];
        this._values = new int[newCapacity];
        this._states = new byte[newCapacity];
        int i = oldCapacity;
        while (i-- > 0) {
            if (oldStates[i] != 1) continue;
            byte o = oldKeys[i];
            int index2 = this.insertionIndex(o);
            this._set[index2] = o;
            this._values[index2] = oldVals[i];
            this._states[index2] = 1;
        }
    }

    public int get(byte key) {
        int index2 = this.index(key);
        return index2 < 0 ? 0 : this._values[index2];
    }

    public void clear() {
        super.clear();
        byte[] keys2 = this._set;
        int[] vals = this._values;
        if (vals == null) {
            return;
        }
        byte[] states = this._states;
        int i = keys2.length;
        while (i-- > 0) {
            keys2[i] = 0;
            vals[i] = 0;
            states[i] = 0;
        }
    }

    public int remove(byte key) {
        int prev = 0;
        int index2 = this.index(key);
        if (index2 >= 0) {
            prev = this._values[index2];
            this.removeAt(index2);
        }
        return prev;
    }

    public boolean equals(Object other) {
        if (!(other instanceof TByteIntHashMap)) {
            return false;
        }
        TByteIntHashMap that = (TByteIntHashMap)other;
        if (that.size() != this.size()) {
            return false;
        }
        return this.forEachEntry(new EqProcedure(that));
    }

    public int hashCode() {
        HashProcedure p = new HashProcedure();
        this.forEachEntry(p);
        return p.getHashCode();
    }

    protected void removeAt(int index2) {
        this._values[index2] = 0;
        super.removeAt(index2);
    }

    public int[] getValues() {
        int[] vals = new int[this.size()];
        int[] v = this._values;
        byte[] states = this._states;
        if (states != null) {
            int i = states.length;
            int j = 0;
            while (i-- > 0) {
                if (states[i] != 1) continue;
                vals[j++] = v[i];
            }
        }
        return vals;
    }

    public byte[] keys() {
        byte[] keys2 = new byte[this.size()];
        byte[] k = this._set;
        byte[] states = this._states;
        if (states != null) {
            int i = states.length;
            int j = 0;
            while (i-- > 0) {
                if (states[i] != 1) continue;
                keys2[j++] = k[i];
            }
        }
        return keys2;
    }

    public boolean containsValue(int val) {
        byte[] states = this._states;
        int[] vals = this._values;
        if (states != null) {
            int i = states.length;
            while (i-- > 0) {
                if (states[i] != 1 || val != vals[i]) continue;
                return true;
            }
        }
        return false;
    }

    public boolean containsKey(byte key) {
        return this.contains(key);
    }

    public boolean forEachKey(TByteProcedure procedure) {
        return this.forEach(procedure);
    }

    public boolean forEachValue(TIntProcedure procedure) {
        byte[] states = this._states;
        int[] values2 = this._values;
        if (states != null) {
            int i = states.length;
            while (i-- > 0) {
                if (states[i] != 1 || procedure.execute(values2[i])) continue;
                return false;
            }
        }
        return true;
    }

    public boolean forEachEntry(TByteIntProcedure procedure) {
        byte[] states = this._states;
        byte[] keys2 = this._set;
        int[] values2 = this._values;
        if (states != null) {
            int i = states.length;
            while (i-- > 0) {
                if (states[i] != 1 || procedure.execute(keys2[i], values2[i])) continue;
                return false;
            }
        }
        return true;
    }

    public boolean retainEntries(TByteIntProcedure procedure) {
        boolean modified = false;
        byte[] states = this._states;
        byte[] keys2 = this._set;
        int[] values2 = this._values;
        if (states != null) {
            int i = states.length;
            while (i-- > 0) {
                if (states[i] != 1 || procedure.execute(keys2[i], values2[i])) continue;
                this.removeAt(i);
                modified = true;
            }
        }
        return modified;
    }

    public void transformValues(TIntFunction function2) {
        byte[] states = this._states;
        int[] values2 = this._values;
        if (states != null) {
            int i = states.length;
            while (i-- > 0) {
                if (states[i] != 1) continue;
                values2[i] = function2.execute(values2[i]);
            }
        }
    }

    public boolean increment(byte key) {
        return this.adjustValue(key, 1);
    }

    public boolean adjustValue(byte key, int amount) {
        int index2 = this.index(key);
        if (index2 < 0) {
            return false;
        }
        int n = index2;
        this._values[n] = this._values[n] + amount;
        return true;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeInt(this._size);
        SerializationProcedure writeProcedure = new SerializationProcedure(stream);
        if (!this.forEachEntry(writeProcedure)) {
            throw writeProcedure.exception;
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        int size = stream.readInt();
        this.setUp(size);
        while (size-- > 0) {
            byte key = stream.readByte();
            int val = stream.readInt();
            this.put(key, val);
        }
    }

    public String toString() {
        final StringBuilder sb = new StringBuilder();
        this.forEachEntry(new TByteIntProcedure(){

            public boolean execute(byte key, int value2) {
                if (sb.length() != 0) {
                    sb.append(',').append(' ');
                }
                sb.append(key);
                sb.append('=');
                sb.append(value2);
                return true;
            }
        });
        sb.append('}');
        sb.insert(0, '{');
        return sb.toString();
    }

    private static final class EqProcedure
    implements TByteIntProcedure {
        private final TByteIntHashMap _otherMap;

        EqProcedure(TByteIntHashMap otherMap) {
            this._otherMap = otherMap;
        }

        public final boolean execute(byte key, int value2) {
            int index2 = this._otherMap.index(key);
            return index2 >= 0 && EqProcedure.eq(value2, this._otherMap.get(key));
        }

        private static boolean eq(int v1, int v2) {
            return v1 == v2;
        }
    }

    private final class HashProcedure
    implements TByteIntProcedure {
        private int h;

        HashProcedure() {
        }

        public int getHashCode() {
            return this.h;
        }

        public final boolean execute(byte key, int value2) {
            this.h += TByteIntHashMap.this._hashingStrategy.computeHashCode(key) ^ HashFunctions.hash(value2);
            return true;
        }
    }
}

