/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.IrElementTransformerVoidWithContext;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrBuilder;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrBuilderKt;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationContainer;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.resolve.deprecation.DeprecationResolver;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0011H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/ObjectClassLowering;", "Lorg/jetbrains/kotlin/backend/common/IrElementTransformerVoidWithContext;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "pendingTransformations", "", "Lkotlin/Function0;", "", "lower", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "process", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "visitClassNew", "Lorg/jetbrains/kotlin/ir/IrStatement;", "declaration", "backend.jvm.lower"})
final class ObjectClassLowering
extends IrElementTransformerVoidWithContext
implements FileLoweringPass {
    @NotNull
    private final JvmBackendContext context;
    @NotNull
    private List<Function0<Unit>> pendingTransformations;

    public ObjectClassLowering(@NotNull JvmBackendContext context) {
        Intrinsics.checkNotNullParameter(context, "context");
        this.context = context;
        this.pendingTransformations = new ArrayList();
    }

    @NotNull
    public final JvmBackendContext getContext() {
        return this.context;
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter(irFile, "irFile");
        irFile.accept(this, null);
        Iterable $this$forEach$iv = this.pendingTransformations;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Function0 it = (Function0)element$iv;
            boolean bl = false;
            it.invoke();
        }
    }

    @Override
    @NotNull
    public IrStatement visitClassNew(@NotNull IrClass declaration) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        this.process(declaration);
        return super.visitClassNew(declaration);
    }

    private final void process(IrClass irClass2) {
        IrConstructor irConstructor2;
        IrField privateInstanceField;
        IrField publicInstanceField;
        block6: {
            if (!IrUtilsKt.isObject(irClass2)) {
                return;
            }
            publicInstanceField = this.context.getCachedDeclarations().getFieldForObjectInstance(irClass2);
            privateInstanceField = this.context.getCachedDeclarations().getPrivateFieldForObjectInstance(irClass2);
            Sequence<IrConstructor> sequence2 = IrUtilsKt.getConstructors(irClass2);
            Iterator<IrConstructor> iterator2 = sequence2.iterator();
            while (iterator2.hasNext()) {
                IrConstructor irConstructor3;
                IrConstructor it = irConstructor3 = iterator2.next();
                boolean bl = false;
                if (!it.isPrimary()) continue;
                irConstructor2 = irConstructor3;
                break block6;
            }
            irConstructor2 = null;
        }
        IrConstructor irConstructor4 = irConstructor2;
        if (irConstructor4 == null) {
            throw new AssertionError((Object)("Object should have a primary constructor: " + irClass2.getName()));
        }
        IrConstructor constructor2 = irConstructor4;
        if (!Intrinsics.areEqual(privateInstanceField, publicInstanceField)) {
            DeclarationIrBuilder $this$process_u24lambda_u242 = LowerUtilsKt.createIrBuilder$default(this.context, (IrSymbol)privateInstanceField.getSymbol(), 0, 0, 6, null);
            boolean bl = false;
            privateInstanceField.setInitializer(ExpressionHelpersKt.irExprBody($this$process_u24lambda_u242, ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$process_u24lambda_u242, constructor2.getSymbol())));
            DeclarationIrBuilder $this$process_u24lambda_u243 = LowerUtilsKt.createIrBuilder$default(this.context, (IrSymbol)publicInstanceField.getSymbol(), 0, 0, 6, null);
            boolean bl2 = false;
            publicInstanceField.setInitializer(ExpressionHelpersKt.irExprBody($this$process_u24lambda_u243, ExpressionHelpersKt.irGetField($this$process_u24lambda_u243, null, privateInstanceField)));
            this.pendingTransformations.add(new Function0<Unit>(privateInstanceField){
                final /* synthetic */ IrField $privateInstanceField;
                {
                    this.$privateInstanceField = $privateInstanceField;
                    super(0);
                }

                public final void invoke() {
                    IrDeclarationParent irDeclarationParent = this.$privateInstanceField.getParent();
                    Intrinsics.checkNotNull(irDeclarationParent, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrDeclarationContainer");
                    ((IrDeclarationContainer)irDeclarationParent).getDeclarations().add(0, this.$privateInstanceField);
                }
            });
        } else {
            DeclarationIrBuilder $this$process_u24lambda_u244 = LowerUtilsKt.createIrBuilder$default(this.context, (IrSymbol)publicInstanceField.getSymbol(), 0, 0, 6, null);
            boolean bl = false;
            publicInstanceField.setInitializer(ExpressionHelpersKt.irExprBody($this$process_u24lambda_u244, ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$process_u24lambda_u244, constructor2.getSymbol())));
        }
        if (!this.context.getState().getLanguageVersionSettings().supportsFeature(LanguageFeature.ProperVisibilityForCompanionObjectInstanceField) && (Intrinsics.areEqual(irClass2.getVisibility(), DescriptorVisibilities.PRIVATE) || Intrinsics.areEqual(irClass2.getVisibility(), DescriptorVisibilities.PROTECTED))) {
            JvmIrBuilder $this$process_u24lambda_u245 = JvmIrBuilderKt.createJvmIrBuilder$default(this.context, irClass2.getSymbol(), 0, 0, 6, null);
            boolean bl = false;
            publicInstanceField.setAnnotations(CollectionsKt.plus((Collection)AdditionalIrUtilsKt.filterOutAnnotations(DeprecationResolver.Companion.getJAVA_DEPRECATED(), publicInstanceField.getAnnotations()), ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$process_u24lambda_u245, $this$process_u24lambda_u245.getIrSymbols().getJavaLangDeprecatedConstructorWithDeprecatedFlag())));
        }
        this.pendingTransformations.add(new Function0<Unit>(publicInstanceField){
            final /* synthetic */ IrField $publicInstanceField;
            {
                this.$publicInstanceField = $publicInstanceField;
                super(0);
            }

            public final void invoke() {
                IrDeclarationParent irDeclarationParent = this.$publicInstanceField.getParent();
                Intrinsics.checkNotNull(irDeclarationParent, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrDeclarationContainer");
                ((IrDeclarationContainer)irDeclarationParent).getDeclarations().add(0, this.$publicInstanceField);
            }
        });
    }
}

