/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.extended;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.diagnostics.LightTreePositioningStrategiesKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.syntax.FirDeclarationSyntaxChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.psi.KtDeclaration;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J(\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/extended/RedundantModalityModifierSyntaxChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/syntax/FirDeclarationSyntaxChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "()V", "checkPsiOrLightTree", "", "element", "source", "Lorg/jetbrains/kotlin/KtSourceElement;", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "isApplicable", "", "checkers"})
public final class RedundantModalityModifierSyntaxChecker
extends FirDeclarationSyntaxChecker<FirDeclaration, KtDeclaration> {
    @NotNull
    public static final RedundantModalityModifierSyntaxChecker INSTANCE = new RedundantModalityModifierSyntaxChecker();

    private RedundantModalityModifierSyntaxChecker() {
    }

    @Override
    public boolean isApplicable(@NotNull FirDeclaration element, @NotNull KtSourceElement source2) {
        Intrinsics.checkNotNullParameter(element, "element");
        Intrinsics.checkNotNullParameter(source2, "source");
        return !(source2.getKind() instanceof KtFakeSourceElementKind) && element instanceof FirMemberDeclaration;
    }

    @Override
    public void checkPsiOrLightTree(@NotNull FirDeclaration element, @NotNull KtSourceElement source2, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(element, "element");
        Intrinsics.checkNotNullParameter(source2, "source");
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        if (!(element instanceof FirMemberDeclaration)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        FirMemberDeclaration $this$modality$iv = (FirMemberDeclaration)element;
        boolean $i$f$getModality = false;
        Modality modality = $this$modality$iv.getStatus().getModality();
        if (modality == null) {
            return;
        }
        Modality modality2 = modality;
        if (modality2 == Modality.FINAL) {
            FirDeclaration firDeclaration = CollectionsKt.last(context.getContainingDeclarations());
            FirClass firClass = firDeclaration instanceof FirClass ? (FirClass)firDeclaration : null;
            if ((firClass != null ? firClass.getClassKind() : null) == ClassKind.INTERFACE) {
                return;
            }
        }
        if (LightTreePositioningStrategiesKt.modalityModifier(source2.getTreeStructure(), source2.getLighterASTNode()) == null) {
            return;
        }
        Modality implicitModality = FirHelpersKt.implicitModality((FirMemberDeclaration)element, context);
        if (modality2 == implicitModality) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source2, FirErrors.INSTANCE.getREDUNDANT_MODALITY_MODIFIER(), (DiagnosticContext)context, null, 8, null);
        }
    }
}

