/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.sourceMap;

import gnu.trove.TObjectIntHashMap;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.js.parser.sourcemaps.JsonArray;
import org.jetbrains.kotlin.js.parser.sourcemaps.JsonNode;
import org.jetbrains.kotlin.js.parser.sourcemaps.JsonNull;
import org.jetbrains.kotlin.js.parser.sourcemaps.JsonNumber;
import org.jetbrains.kotlin.js.parser.sourcemaps.JsonObject;
import org.jetbrains.kotlin.js.parser.sourcemaps.JsonString;
import org.jetbrains.kotlin.js.sourceMap.SourceMapBuilder;
import org.jetbrains.kotlin.js.util.TextOutput;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u00002\u00020\u0001:\u000256B\u001f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020 H\u0016J:\u0010\"\u001a\u00020 2\u0006\u0010#\u001a\u00020\u00072\b\u0010$\u001a\u0004\u0018\u00010%2\u000e\u0010&\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\r2\u0006\u0010'\u001a\u00020\u00142\u0006\u0010(\u001a\u00020\u0014H\u0016J\u0010\u0010)\u001a\u00020 2\u0006\u0010*\u001a\u00020+H\u0002J\u0010\u0010,\u001a\u00020 2\u0006\u0010*\u001a\u00020+H\u0002J\b\u0010-\u001a\u00020\u0007H\u0016J\b\u0010.\u001a\u00020\u0003H\u0016J*\u0010/\u001a\u00020\u00142\u0006\u0010#\u001a\u00020\u00072\b\u0010$\u001a\u0004\u0018\u00010%2\u000e\u00100\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\rH\u0002J\b\u00101\u001a\u00020 H\u0016J\u0010\u00102\u001a\u00020 2\u0006\u00103\u001a\u00020\u0014H\u0016J\b\u00104\u001a\u00020 H\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000b\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0010\u001a\u00060\u0011j\u0002`\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lorg/jetbrains/kotlin/js/sourceMap/SourceMap3Builder;", "Lorg/jetbrains/kotlin/js/sourceMap/SourceMapBuilder;", "generatedFile", "Ljava/io/File;", "textOutput", "Lorg/jetbrains/kotlin/js/util/TextOutput;", "pathPrefix", "", "(Ljava/io/File;Lorg/jetbrains/kotlin/js/util/TextOutput;Ljava/lang/String;)V", "currentMappingIsEmpty", "", "orderedSourceContentSuppliers", "", "Ljava/util/function/Supplier;", "Ljava/io/Reader;", "orderedSources", "out", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "previousGeneratedColumn", "", "previousMappingOffset", "previousPreviousSourceColumn", "previousPreviousSourceIndex", "previousPreviousSourceLine", "previousSourceColumn", "previousSourceIndex", "previousSourceLine", "sources", "Lgnu/trove/TObjectIntHashMap;", "Lorg/jetbrains/kotlin/js/sourceMap/SourceMap3Builder$SourceKey;", "addEmptyMapping", "", "addLink", "addMapping", "source", "fileIdentity", "", "sourceContent", "sourceLine", "sourceColumn", "appendSources", "json", "Lorg/jetbrains/kotlin/js/parser/sourcemaps/JsonObject;", "appendSourcesContent", "build", "getOutFile", "getSourceIndex", "contentSupplier", "newLine", "skipLinesAtBeginning", "count", "startMapping", "Base64VLQ", "SourceKey", "js.sourcemap"})
public final class SourceMap3Builder
implements SourceMapBuilder {
    @Nullable
    private final File generatedFile;
    @NotNull
    private final TextOutput textOutput;
    @NotNull
    private final String pathPrefix;
    @NotNull
    private final StringBuilder out;
    @NotNull
    private final TObjectIntHashMap<SourceKey> sources;
    @NotNull
    private final List<String> orderedSources;
    @NotNull
    private final List<Supplier<Reader>> orderedSourceContentSuppliers;
    private int previousGeneratedColumn;
    private int previousSourceIndex;
    private int previousSourceLine;
    private int previousSourceColumn;
    private int previousMappingOffset;
    private int previousPreviousSourceIndex;
    private int previousPreviousSourceLine;
    private int previousPreviousSourceColumn;
    private boolean currentMappingIsEmpty;

    public SourceMap3Builder(@Nullable File generatedFile, @NotNull TextOutput textOutput, @NotNull String pathPrefix) {
        Intrinsics.checkNotNullParameter(textOutput, "textOutput");
        Intrinsics.checkNotNullParameter(pathPrefix, "pathPrefix");
        this.generatedFile = generatedFile;
        this.textOutput = textOutput;
        this.pathPrefix = pathPrefix;
        this.out = new StringBuilder(8192);
        this.sources = new TObjectIntHashMap<SourceKey>(){

            public int get(@NotNull SourceKey key) {
                Intrinsics.checkNotNullParameter(key, "key");
                int index2 = this.index(key);
                return index2 < 0 ? -1 : this._values[index2];
            }
        };
        this.orderedSources = new ArrayList();
        this.orderedSourceContentSuppliers = new ArrayList();
        this.previousGeneratedColumn = -1;
        this.currentMappingIsEmpty = true;
    }

    @Override
    @NotNull
    public File getOutFile() {
        File file2 = this.generatedFile;
        Intrinsics.checkNotNull(file2);
        return new File(file2.getParentFile(), this.generatedFile.getName() + ".map");
    }

    @Override
    @NotNull
    public String build() {
        JsonString jsonString;
        String string2;
        Map<String, JsonNode> map;
        JsonObject json = new JsonObject(new Pair[0]);
        json.getProperties().put("version", new JsonNumber(3.0));
        if (this.generatedFile != null) {
            map = json.getProperties();
            string2 = "file";
            String string3 = this.generatedFile.getName();
            Intrinsics.checkNotNullExpressionValue(string3, "generatedFile.name");
            jsonString = new JsonString(string3);
            map.put(string2, jsonString);
        }
        this.appendSources(json);
        this.appendSourcesContent(json);
        json.getProperties().put("names", new JsonArray(new JsonNode[0]));
        map = json.getProperties();
        string2 = "mappings";
        String string4 = this.out.toString();
        Intrinsics.checkNotNullExpressionValue(string4, "out.toString()");
        jsonString = new JsonString(string4);
        map.put(string2, jsonString);
        return json.toString();
    }

    /*
     * WARNING - void declaration
     */
    private final void appendSources(JsonObject json) {
        void destination$iv;
        void $this$mapTo$iv;
        Map<String, JsonNode> map = json.getProperties();
        String string2 = "sources";
        Object object = this.orderedSources;
        Collection collection = new ArrayList();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            String string3 = (String)item$iv;
            void var11_11 = destination$iv;
            boolean bl = false;
            var11_11.add(new JsonString(this.pathPrefix + (String)it));
        }
        List list2 = (List)destination$iv;
        object = new JsonArray(list2);
        map.put(string2, (JsonNode)object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void appendSourcesContent(JsonObject json) {
        void destination$iv;
        void $this$mapTo$iv;
        Map<String, JsonNode> map = json.getProperties();
        String string2 = "sourcesContent";
        Object object = this.orderedSourceContentSuppliers;
        Collection collection = new ArrayList();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            Object object2;
            Supplier supplier = (Supplier)item$iv;
            void var15_18 = destination$iv;
            boolean bl = false;
            try {
                JsonNode jsonNode;
                void it;
                object2 = (Closeable)it.get();
                Throwable throwable = null;
                try {
                    Reader reader = (Reader)object2;
                    boolean bl2 = false;
                    jsonNode = reader != null ? (JsonNode)new JsonString(TextStreamsKt.readText(reader)) : (JsonNode)JsonNull.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object2, throwable);
                }
                object2 = jsonNode;
            }
            catch (IOException e) {
                System.err.println("An exception occurred during embedding sources into source map");
                e.printStackTrace();
                object2 = JsonNull.INSTANCE;
            }
            var15_18.add(object2);
        }
        List list2 = (List)destination$iv;
        object = new JsonArray(list2);
        map.put(string2, (JsonNode)object);
    }

    @Override
    public void newLine() {
        this.out.append(';');
        this.previousGeneratedColumn = -1;
    }

    @Override
    public void skipLinesAtBeginning(int count) {
        this.out.insert(0, StringsKt.repeat(";", count));
    }

    private final int getSourceIndex(String source2, Object fileIdentity, Supplier<Reader> contentSupplier2) {
        SourceKey key = new SourceKey(source2, fileIdentity);
        int sourceIndex = this.sources.get(key);
        if (sourceIndex == -1) {
            sourceIndex = this.orderedSources.size();
            this.sources.put(key, sourceIndex);
            this.orderedSources.add(source2);
            this.orderedSourceContentSuppliers.add(contentSupplier2);
        }
        return sourceIndex;
    }

    @Override
    public void addMapping(@NotNull String source2, @Nullable Object fileIdentity, @NotNull Supplier<Reader> sourceContent, int sourceLine, int sourceColumn) {
        Intrinsics.checkNotNullParameter(source2, "source");
        Intrinsics.checkNotNullParameter(sourceContent, "sourceContent");
        int sourceIndex = this.getSourceIndex(StringsKt.replace$default(source2, File.separatorChar, '/', false, 4, null), fileIdentity, sourceContent);
        if (!this.currentMappingIsEmpty && this.previousSourceIndex == sourceIndex && this.previousSourceLine == sourceLine && this.previousSourceColumn == sourceColumn) {
            return;
        }
        this.startMapping();
        Base64VLQ.INSTANCE.encode(this.out, sourceIndex - this.previousSourceIndex);
        this.previousSourceIndex = sourceIndex;
        Base64VLQ.INSTANCE.encode(this.out, sourceLine - this.previousSourceLine);
        this.previousSourceLine = sourceLine;
        Base64VLQ.INSTANCE.encode(this.out, sourceColumn - this.previousSourceColumn);
        this.previousSourceColumn = sourceColumn;
        this.currentMappingIsEmpty = false;
    }

    @Override
    public void addEmptyMapping() {
        if (!this.currentMappingIsEmpty) {
            this.startMapping();
            this.currentMappingIsEmpty = true;
        }
    }

    private final void startMapping() {
        boolean newGroupStarted;
        boolean bl = newGroupStarted = this.previousGeneratedColumn == -1;
        if (newGroupStarted) {
            this.previousGeneratedColumn = 0;
        }
        int columnDiff = this.textOutput.getColumn() - this.previousGeneratedColumn;
        if (!newGroupStarted) {
            this.out.append(',');
        }
        if (columnDiff > 0 || newGroupStarted) {
            Base64VLQ.INSTANCE.encode(this.out, columnDiff);
            this.previousGeneratedColumn = this.textOutput.getColumn();
            this.previousMappingOffset = this.out.length();
            this.previousPreviousSourceIndex = this.previousSourceIndex;
            this.previousPreviousSourceLine = this.previousSourceLine;
            this.previousPreviousSourceColumn = this.previousSourceColumn;
        } else {
            this.out.setLength(this.previousMappingOffset);
            this.previousSourceIndex = this.previousPreviousSourceIndex;
            this.previousSourceLine = this.previousPreviousSourceLine;
            this.previousSourceColumn = this.previousPreviousSourceColumn;
        }
    }

    @Override
    public void addLink() {
        this.textOutput.print("\n//# sourceMappingURL=");
        File file2 = this.generatedFile;
        Intrinsics.checkNotNull(file2);
        this.textOutput.print(file2.getName());
        this.textOutput.print(".map\n");
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u0005J\t\u0010\u0006\u001a\u00020\u0003H\u00c2\u0003J\u000b\u0010\u0007\u001a\u0004\u0018\u00010\u0001H\u00c2\u0003J\u001f\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0001H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u0003H\u00d6\u0001R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/js/sourceMap/SourceMap3Builder$SourceKey;", "", "sourcePath", "", "fileIdentity", "(Ljava/lang/String;Ljava/lang/Object;)V", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "js.sourcemap"})
    private static final class SourceKey {
        @NotNull
        private final String sourcePath;
        @Nullable
        private final Object fileIdentity;

        public SourceKey(@NotNull String sourcePath, @Nullable Object fileIdentity) {
            Intrinsics.checkNotNullParameter(sourcePath, "sourcePath");
            this.sourcePath = sourcePath;
            this.fileIdentity = fileIdentity;
        }

        @NotNull
        public final SourceKey copy(@NotNull String sourcePath, @Nullable Object fileIdentity) {
            Intrinsics.checkNotNullParameter(sourcePath, "sourcePath");
            return new SourceKey(sourcePath, fileIdentity);
        }

        public static /* synthetic */ SourceKey copy$default(SourceKey sourceKey, String string2, Object object, int n, Object object2) {
            if ((n & 1) != 0) {
                string2 = sourceKey.sourcePath;
            }
            if ((n & 2) != 0) {
                object = sourceKey.fileIdentity;
            }
            return sourceKey.copy(string2, object);
        }

        @NotNull
        public String toString() {
            return "SourceKey(sourcePath=" + this.sourcePath + ", fileIdentity=" + this.fileIdentity + ')';
        }

        public int hashCode() {
            int result2 = this.sourcePath.hashCode();
            result2 = result2 * 31 + (this.fileIdentity == null ? 0 : this.fileIdentity.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SourceKey)) {
                return false;
            }
            SourceKey sourceKey = (SourceKey)other;
            if (!Intrinsics.areEqual(this.sourcePath, sourceKey.sourcePath)) {
                return false;
            }
            return Intrinsics.areEqual(this.fileIdentity, sourceKey.fileIdentity);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0019\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u000b\u001a\u00020\f2\n\u0010\r\u001a\u00060\u000ej\u0002`\u000f2\u0006\u0010\u0010\u001a\u00020\u0007J\u0010\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0007H\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0005\u0010\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/js/sourceMap/SourceMap3Builder$Base64VLQ;", "", "()V", "BASE64_MAP", "", "getBASE64_MAP$annotations", "VLQ_BASE", "", "VLQ_BASE_MASK", "VLQ_BASE_SHIFT", "VLQ_CONTINUATION_BIT", "encode", "", "out", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "value", "toVLQSigned", "js.sourcemap"})
    private static final class Base64VLQ {
        @NotNull
        public static final Base64VLQ INSTANCE = new Base64VLQ();
        @NotNull
        private static final char[] BASE64_MAP;

        private Base64VLQ() {
        }

        private final int toVLQSigned(int value2) {
            return value2 < 0 ? (-value2 << 1) + 1 : value2 << 1;
        }

        public final void encode(@NotNull StringBuilder out, int value2) {
            Intrinsics.checkNotNullParameter(out, "out");
            int value3 = this.toVLQSigned(value2);
            do {
                int digit = value3 & 0x1F;
                if ((value3 >>>= 5) > 0) {
                    digit |= 0x20;
                }
                out.append(BASE64_MAP[digit]);
            } while (value3 > 0);
        }

        static {
            char[] cArray = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".toCharArray();
            Intrinsics.checkNotNullExpressionValue(cArray, "this as java.lang.String).toCharArray()");
            BASE64_MAP = cArray;
        }
    }
}

