/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi.psiUtil;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.AbstractElementManipulator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\"\u0010\u0007\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/psi/psiUtil/StringTemplateExpressionManipulator;", "Lcom/intellij/psi/AbstractElementManipulator;", "Lorg/jetbrains/kotlin/psi/KtStringTemplateExpression;", "()V", "getRangeInElement", "Lcom/intellij/openapi/util/TextRange;", "element", "handleContentChange", "range", "newContent", "", "frontend"})
public final class StringTemplateExpressionManipulator
extends AbstractElementManipulator<KtStringTemplateExpression> {
    @Nullable
    public KtStringTemplateExpression handleContentChange(@NotNull KtStringTemplateExpression element, @NotNull TextRange range, @NotNull String newContent) {
        Intrinsics.checkNotNullParameter(element, "element");
        Intrinsics.checkNotNullParameter(range, "range");
        Intrinsics.checkNotNullParameter(newContent, "newContent");
        ASTNode aSTNode = element.getNode();
        Intrinsics.checkNotNullExpressionValue(aSTNode, "element.node");
        ASTNode node = aSTNode;
        String string2 = node.getFirstChildNode().getTextLength() == 1 ? StringUtil.escapeStringCharacters((String)newContent) : newContent;
        Intrinsics.checkNotNullExpressionValue(string2, "if (node.firstChildNode.\u2026wContent) else newContent");
        String content2 = string2;
        String string3 = node.getText();
        Intrinsics.checkNotNullExpressionValue(string3, "node.text");
        String oldText = string3;
        StringBuilder stringBuilder2 = new StringBuilder();
        String string4 = oldText.substring(0, range.getStartOffset());
        Intrinsics.checkNotNullExpressionValue(string4, "this as java.lang.String\u2026ing(startIndex, endIndex)");
        StringBuilder stringBuilder3 = stringBuilder2.append(string4).append(content2);
        String string5 = oldText.substring(range.getEndOffset());
        Intrinsics.checkNotNullExpressionValue(string5, "this as java.lang.String).substring(startIndex)");
        String newText = stringBuilder3.append(string5).toString();
        Project project = element.getProject();
        Intrinsics.checkNotNullExpressionValue(project, "element.project");
        KtExpression expression2 = new KtPsiFactory(project, false, 2, null).createExpression(newText);
        node.replaceAllChildrenToChildrenOf(expression2.getNode());
        return (KtStringTemplateExpression)node.getPsi(KtStringTemplateExpression.class);
    }

    @NotNull
    public TextRange getRangeInElement(@NotNull KtStringTemplateExpression element) {
        Intrinsics.checkNotNullParameter(element, "element");
        return KtPsiUtilKt.getContentRange(element);
    }
}

