/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.container.DefaultImplementation;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory3;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.UpperBoundViolatedReporter;
import org.jetbrains.kotlin.types.AbbreviatedType;
import org.jetbrains.kotlin.types.DynamicTypesKt;
import org.jetbrains.kotlin.types.FlexibleType;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@DefaultImplementation(impl=UpperBoundChecker.class)
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J>\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0004J`\u0010\u0012\u001a\u00020\u00132\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u00172\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f2 \b\u0002\u0010\u0018\u001a\u001a\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0016J(\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u0006H\u0002J&\u0010\u001f\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010 \u001a\u00020!J \u0010\"\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\b2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/resolve/UpperBoundChecker;", "", "typeChecker", "Lorg/jetbrains/kotlin/types/checker/KotlinTypeChecker;", "(Lorg/jetbrains/kotlin/types/checker/KotlinTypeChecker;)V", "checkBound", "", "bound", "Lorg/jetbrains/kotlin/types/KotlinType;", "argumentType", "argumentReference", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "substitutor", "Lorg/jetbrains/kotlin/types/TypeSubstitutor;", "typeAliasUsageElement", "Lorg/jetbrains/kotlin/psi/KtElement;", "upperBoundViolatedReporter", "Lorg/jetbrains/kotlin/resolve/UpperBoundViolatedReporter;", "checkBounds", "", "typeParameterDescriptor", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "diagnosticForTypeAliases", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory3;", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "checkBoundsForAbbreviatedSupertype", "type", "typeReference", "reportWarning", "checkBoundsInSupertype", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "checkBoundsOfExpandedTypeAlias", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "frontend"})
public class UpperBoundChecker {
    @NotNull
    private final KotlinTypeChecker typeChecker;

    public UpperBoundChecker(@NotNull KotlinTypeChecker typeChecker) {
        Intrinsics.checkNotNullParameter(typeChecker, "typeChecker");
        this.typeChecker = typeChecker;
    }

    public void checkBoundsOfExpandedTypeAlias(@NotNull KotlinType type2, @NotNull KtExpression expression2, @NotNull BindingTrace trace) {
        Intrinsics.checkNotNullParameter(type2, "type");
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(trace, "trace");
    }

    public void checkBounds(@Nullable KtTypeReference argumentReference, @NotNull KotlinType argumentType, @NotNull TypeParameterDescriptor typeParameterDescriptor, @NotNull TypeSubstitutor substitutor2, @NotNull BindingTrace trace, @Nullable KtElement typeAliasUsageElement, @NotNull DiagnosticFactory3<KtElement, KotlinType, KotlinType, ClassifierDescriptor> diagnosticForTypeAliases) {
        Intrinsics.checkNotNullParameter(argumentType, "argumentType");
        Intrinsics.checkNotNullParameter(typeParameterDescriptor, "typeParameterDescriptor");
        Intrinsics.checkNotNullParameter(substitutor2, "substitutor");
        Intrinsics.checkNotNullParameter(trace, "trace");
        Intrinsics.checkNotNullParameter(diagnosticForTypeAliases, "diagnosticForTypeAliases");
        if (typeParameterDescriptor.getUpperBounds().isEmpty()) {
            return;
        }
        UpperBoundViolatedReporter diagnosticsReporter = new UpperBoundViolatedReporter(trace, argumentType, typeParameterDescriptor, null, diagnosticForTypeAliases, 8, null);
        for (KotlinType bound : typeParameterDescriptor.getUpperBounds()) {
            Intrinsics.checkNotNullExpressionValue(bound, "bound");
            this.checkBound(bound, argumentType, argumentReference, substitutor2, typeAliasUsageElement, diagnosticsReporter);
        }
    }

    public static /* synthetic */ void checkBounds$default(UpperBoundChecker upperBoundChecker, KtTypeReference ktTypeReference, KotlinType kotlinType, TypeParameterDescriptor typeParameterDescriptor, TypeSubstitutor typeSubstitutor2, BindingTrace bindingTrace, KtElement ktElement, DiagnosticFactory3 diagnosticFactory3, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: checkBounds");
        }
        if ((n & 0x20) != 0) {
            ktElement = null;
        }
        if ((n & 0x40) != 0) {
            DiagnosticFactory3<KtElement, KotlinType, KotlinType, ClassifierDescriptor> diagnosticFactory32 = Errors.UPPER_BOUND_VIOLATED_IN_TYPEALIAS_EXPANSION;
            Intrinsics.checkNotNullExpressionValue(diagnosticFactory32, "UPPER_BOUND_VIOLATED_IN_TYPEALIAS_EXPANSION");
            diagnosticFactory3 = diagnosticFactory32;
        }
        upperBoundChecker.checkBounds(ktTypeReference, kotlinType, typeParameterDescriptor, typeSubstitutor2, bindingTrace, ktElement, diagnosticFactory3);
    }

    public final void checkBoundsInSupertype(@NotNull KtTypeReference typeReference, @NotNull KotlinType type2, @NotNull BindingTrace trace, @NotNull LanguageVersionSettings languageVersionSettings) {
        boolean bl;
        Intrinsics.checkNotNullParameter(typeReference, "typeReference");
        Intrinsics.checkNotNullParameter(type2, "type");
        Intrinsics.checkNotNullParameter(trace, "trace");
        Intrinsics.checkNotNullParameter(languageVersionSettings, "languageVersionSettings");
        if (KotlinTypeKt.isError(type2)) {
            return;
        }
        KtTypeElement ktTypeElement = typeReference.getTypeElement();
        if (ktTypeElement == null) {
            return;
        }
        KtTypeElement typeElement = ktTypeElement;
        List<TypeParameterDescriptor> list2 = type2.getConstructor().getParameters();
        Intrinsics.checkNotNullExpressionValue(list2, "type.constructor.parameters");
        List<TypeParameterDescriptor> parameters2 = list2;
        List<TypeProjection> arguments2 = type2.getArguments();
        boolean bl2 = bl = parameters2.size() == arguments2.size();
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        List<KtTypeReference> list3 = typeElement.getTypeArgumentsAsTypes();
        Intrinsics.checkNotNullExpressionValue(list3, "typeElement.typeArgumentsAsTypes");
        List<KtTypeReference> ktTypeArguments = list3;
        if (FlexibleTypesKt.isFlexible(type2) && !DynamicTypesKt.isDynamic(type2)) {
            boolean bl3;
            boolean bl4 = bl3 = ktTypeArguments.size() == 2;
            if (_Assertions.ENABLED && !bl3) {
                boolean $i$a$-assert-UpperBoundChecker$checkBoundsInSupertype$22 = false;
                String $i$a$-assert-UpperBoundChecker$checkBoundsInSupertype$22 = "Flexible type cannot be denoted in Kotlin otherwise than as ft<T1, T2>, but was: " + PsiUtilsKt.getElementTextWithContext(typeReference);
                throw new AssertionError((Object)$i$a$-assert-UpperBoundChecker$checkBoundsInSupertype$22);
            }
            FlexibleType flexibleType = FlexibleTypesKt.asFlexibleType(type2);
            KtTypeReference ktTypeReference = ktTypeArguments.get(0);
            Intrinsics.checkNotNullExpressionValue(ktTypeReference, "ktTypeArguments[0]");
            this.checkBoundsInSupertype(ktTypeReference, flexibleType.getLowerBound(), trace, languageVersionSettings);
            KtTypeReference ktTypeReference2 = ktTypeArguments.get(1);
            Intrinsics.checkNotNullExpressionValue(ktTypeReference2, "ktTypeArguments[1]");
            this.checkBoundsInSupertype(ktTypeReference2, flexibleType.getUpperBound(), trace, languageVersionSettings);
            return;
        }
        if (type2 instanceof AbbreviatedType) {
            this.checkBoundsForAbbreviatedSupertype(type2, trace, typeReference, ktTypeArguments.size() != arguments2.size() && !languageVersionSettings.supportsFeature(LanguageFeature.ReportMissingUpperBoundsViolatedErrorOnAbbreviationAtSupertypes));
            return;
        }
        if (ktTypeArguments.size() != arguments2.size()) {
            return;
        }
        TypeSubstitutor typeSubstitutor2 = TypeSubstitutor.create(type2);
        Intrinsics.checkNotNullExpressionValue(typeSubstitutor2, "create(type)");
        TypeSubstitutor substitutor2 = typeSubstitutor2;
        int n = ktTypeArguments.size();
        for (int i = 0; i < n; ++i) {
            KtTypeReference ktTypeArgument;
            if (ktTypeArguments.get(i) == null) continue;
            KotlinType kotlinType = arguments2.get(i).getType();
            Intrinsics.checkNotNullExpressionValue(kotlinType, "arguments[i].type");
            this.checkBoundsInSupertype(ktTypeArgument, kotlinType, trace, languageVersionSettings);
            KotlinType kotlinType2 = arguments2.get(i).getType();
            Intrinsics.checkNotNullExpressionValue(kotlinType2, "arguments[i].type");
            TypeParameterDescriptor typeParameterDescriptor = parameters2.get(i);
            Intrinsics.checkNotNullExpressionValue(typeParameterDescriptor, "parameters[i]");
            UpperBoundChecker.checkBounds$default(this, ktTypeArgument, kotlinType2, typeParameterDescriptor, substitutor2, trace, null, null, 96, null);
        }
    }

    private final void checkBoundsForAbbreviatedSupertype(KotlinType type2, BindingTrace trace, KtTypeReference typeReference, boolean reportWarning) {
        List<TypeParameterDescriptor> list2 = type2.getConstructor().getParameters();
        Intrinsics.checkNotNullExpressionValue(list2, "type.constructor.parameters");
        List<TypeParameterDescriptor> parameters2 = list2;
        List<TypeProjection> arguments2 = type2.getArguments();
        TypeSubstitutor typeSubstitutor2 = TypeSubstitutor.create(type2);
        Intrinsics.checkNotNullExpressionValue(typeSubstitutor2, "create(type)");
        TypeSubstitutor substitutor2 = typeSubstitutor2;
        DiagnosticFactory3<KtElement, KotlinType, KotlinType, ClassifierDescriptor> diagnostic = reportWarning ? Errors.UPPER_BOUND_VIOLATED_IN_TYPEALIAS_EXPANSION_WARNING : Errors.UPPER_BOUND_VIOLATED_IN_TYPEALIAS_EXPANSION;
        int n = arguments2.size();
        for (int i = 0; i < n; ++i) {
            KotlinType argumentType;
            if (arguments2.get(i).isStarProjection()) continue;
            Intrinsics.checkNotNullExpressionValue(arguments2.get(i).getType(), "arguments[i].type");
            this.checkBoundsForAbbreviatedSupertype(argumentType, trace, typeReference, reportWarning);
            TypeParameterDescriptor typeParameterDescriptor = parameters2.get(i);
            Intrinsics.checkNotNullExpressionValue(typeParameterDescriptor, "parameters[i]");
            KtElement ktElement = typeReference;
            Intrinsics.checkNotNullExpressionValue(diagnostic, "diagnostic");
            this.checkBounds(null, argumentType, typeParameterDescriptor, substitutor2, trace, ktElement, diagnostic);
        }
    }

    protected final boolean checkBound(@NotNull KotlinType bound, @NotNull KotlinType argumentType, @Nullable KtTypeReference argumentReference, @NotNull TypeSubstitutor substitutor2, @Nullable KtElement typeAliasUsageElement, @NotNull UpperBoundViolatedReporter upperBoundViolatedReporter) {
        Intrinsics.checkNotNullParameter(bound, "bound");
        Intrinsics.checkNotNullParameter(argumentType, "argumentType");
        Intrinsics.checkNotNullParameter(substitutor2, "substitutor");
        Intrinsics.checkNotNullParameter(upperBoundViolatedReporter, "upperBoundViolatedReporter");
        KotlinType kotlinType = substitutor2.safeSubstitute(bound, Variance.INVARIANT);
        Intrinsics.checkNotNullExpressionValue(kotlinType, "substitutor.safeSubstitu\u2026ound, Variance.INVARIANT)");
        KotlinType substitutedBound = kotlinType;
        if (!this.typeChecker.isSubtypeOf(argumentType, substitutedBound)) {
            if (argumentReference != null) {
                upperBoundViolatedReporter.report(argumentReference, substitutedBound);
            } else if (typeAliasUsageElement != null && !TypeUtilsKt.containsTypeAliasParameters(substitutedBound) && !TypeUtilsKt.containsTypeAliasParameters(argumentType)) {
                upperBoundViolatedReporter.reportForTypeAliasExpansion(typeAliasUsageElement, substitutedBound);
            }
            return false;
        }
        return true;
    }

    public static /* synthetic */ boolean checkBound$default(UpperBoundChecker upperBoundChecker, KotlinType kotlinType, KotlinType kotlinType2, KtTypeReference ktTypeReference, TypeSubstitutor typeSubstitutor2, KtElement ktElement, UpperBoundViolatedReporter upperBoundViolatedReporter, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: checkBound");
        }
        if ((n & 0x10) != 0) {
            ktElement = null;
        }
        return upperBoundChecker.checkBound(kotlinType, kotlinType2, ktTypeReference, typeSubstitutor2, ktElement, upperBoundViolatedReporter);
    }
}

