/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.constants;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstantKt;
import org.jetbrains.kotlin.resolve.constants.PrimitiveTypeUtilKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeRefinement;
import org.jetbrains.kotlin.types.checker.KotlinTypeRefiner;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\f\u001a\u00020\rH\u0002J\b\u0010\u000e\u001a\u00020\rH\u0002J\u0018\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u000bH\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\n\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0016J\u000e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0019H\u0016J\u0006\u0010\u001a\u001a\u00020\u0003J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001cH\u0016J\u0010\u0010\u001e\u001a\u00020\u00012\u0006\u0010\u001f\u001a\u00020 H\u0017J\b\u0010!\u001a\u00020\"H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/resolve/constants/IntegerValueTypeConstructor;", "Lorg/jetbrains/kotlin/types/TypeConstructor;", "value", "", "module", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "parameters", "Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant$Parameters;", "(JLorg/jetbrains/kotlin/descriptors/ModuleDescriptor;Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant$Parameters;)V", "supertypes", "Ljava/util/ArrayList;", "Lorg/jetbrains/kotlin/types/KotlinType;", "addSignedSuperTypes", "", "addUnsignedSuperTypes", "checkBoundsAndAddSuperType", "kotlinType", "getBuiltIns", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "getDeclarationDescriptor", "", "getParameters", "", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "getSupertypes", "", "getValue", "isDenotable", "", "isFinal", "refine", "kotlinTypeRefiner", "Lorg/jetbrains/kotlin/types/checker/KotlinTypeRefiner;", "toString", "", "descriptors"})
public final class IntegerValueTypeConstructor
implements TypeConstructor {
    private final long value;
    @NotNull
    private final ModuleDescriptor module;
    @NotNull
    private final ArrayList<KotlinType> supertypes;

    public IntegerValueTypeConstructor(long value2, @NotNull ModuleDescriptor module2, @NotNull CompileTimeConstant.Parameters parameters2) {
        Intrinsics.checkNotNullParameter(module2, "module");
        Intrinsics.checkNotNullParameter(parameters2, "parameters");
        this.value = value2;
        this.module = module2;
        this.supertypes = new ArrayList(4);
        boolean isUnsigned = parameters2.isUnsignedNumberLiteral();
        boolean isConvertable = parameters2.isConvertableConstVal();
        if (isUnsigned || isConvertable) {
            boolean bl = CompileTimeConstantKt.hasUnsignedTypesInModuleDependencies(this.module);
            if (_Assertions.ENABLED && !bl) {
                boolean bl2 = false;
                String string2 = "Unsigned types should be on classpath to create an unsigned type constructor";
                throw new AssertionError((Object)string2);
            }
        }
        if (isConvertable) {
            this.addSignedSuperTypes();
            this.addUnsignedSuperTypes();
        } else if (isUnsigned) {
            this.addUnsignedSuperTypes();
        } else {
            this.addSignedSuperTypes();
        }
    }

    private final void addSignedSuperTypes() {
        SimpleType simpleType2 = this.getBuiltIns().getIntType();
        Intrinsics.checkNotNullExpressionValue(simpleType2, "builtIns.intType");
        this.checkBoundsAndAddSuperType(this.value, simpleType2);
        SimpleType simpleType3 = this.getBuiltIns().getByteType();
        Intrinsics.checkNotNullExpressionValue(simpleType3, "builtIns.byteType");
        this.checkBoundsAndAddSuperType(this.value, simpleType3);
        SimpleType simpleType4 = this.getBuiltIns().getShortType();
        Intrinsics.checkNotNullExpressionValue(simpleType4, "builtIns.shortType");
        this.checkBoundsAndAddSuperType(this.value, simpleType4);
        this.supertypes.add(this.getBuiltIns().getLongType());
    }

    private final void addUnsignedSuperTypes() {
        this.checkBoundsAndAddSuperType(this.value, PrimitiveTypeUtilKt.unsignedType(this.module, StandardNames.FqNames.uInt));
        this.checkBoundsAndAddSuperType(this.value, PrimitiveTypeUtilKt.unsignedType(this.module, StandardNames.FqNames.uByte));
        this.checkBoundsAndAddSuperType(this.value, PrimitiveTypeUtilKt.unsignedType(this.module, StandardNames.FqNames.uShort));
        this.supertypes.add(PrimitiveTypeUtilKt.unsignedType(this.module, StandardNames.FqNames.uLong));
    }

    private final void checkBoundsAndAddSuperType(long value2, KotlinType kotlinType) {
        long l = PrimitiveTypeUtilKt.minValue(kotlinType);
        boolean bl = value2 <= PrimitiveTypeUtilKt.maxValue(kotlinType) ? l <= value2 : false;
        if (bl) {
            this.supertypes.add(kotlinType);
        }
    }

    @Override
    @NotNull
    public Collection<KotlinType> getSupertypes() {
        return this.supertypes;
    }

    @Override
    @NotNull
    public List<TypeParameterDescriptor> getParameters() {
        return CollectionsKt.emptyList();
    }

    @Override
    public boolean isFinal() {
        return false;
    }

    @Override
    public boolean isDenotable() {
        return false;
    }

    @Nullable
    public Void getDeclarationDescriptor() {
        return null;
    }

    public final long getValue() {
        return this.value;
    }

    @Override
    @NotNull
    public KotlinBuiltIns getBuiltIns() {
        return this.module.getBuiltIns();
    }

    @Override
    @TypeRefinement
    @NotNull
    public TypeConstructor refine(@NotNull KotlinTypeRefiner kotlinTypeRefiner) {
        Intrinsics.checkNotNullParameter(kotlinTypeRefiner, "kotlinTypeRefiner");
        return this;
    }

    @NotNull
    public String toString() {
        return "IntegerValueType(" + this.value + ')';
    }
}

